# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_fsu_collection_details import CreateFsuCollectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDbFsuCollectionDetails(CreateFsuCollectionDetails):
    """
    Details to create a 'DB' type Exadata Fleet Update Collection.
    Targets belonging to another 'DB' type Exadata Fleet Update Collection will be rejected.
    """

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_11204"
    SOURCE_MAJOR_VERSION_DB_11204 = "DB_11204"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_121"
    SOURCE_MAJOR_VERSION_DB_121 = "DB_121"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_122"
    SOURCE_MAJOR_VERSION_DB_122 = "DB_122"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_18"
    SOURCE_MAJOR_VERSION_DB_18 = "DB_18"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_19"
    SOURCE_MAJOR_VERSION_DB_19 = "DB_19"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_23"
    SOURCE_MAJOR_VERSION_DB_23 = "DB_23"

    #: A constant which can be used with the source_major_version property of a CreateDbFsuCollectionDetails.
    #: This constant has a value of "DB_26"
    SOURCE_MAJOR_VERSION_DB_26 = "DB_26"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDbFsuCollectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateDbFsuCollectionDetails.type` attribute
        of this class is ``DB`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDbFsuCollectionDetails.
        :type display_name: str

        :param type:
            The value to assign to the type property of this CreateDbFsuCollectionDetails.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK"
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this CreateDbFsuCollectionDetails.
            Allowed values for this property are: "EXACS", "EXACC"
        :type service_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDbFsuCollectionDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDbFsuCollectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDbFsuCollectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param source_major_version:
            The value to assign to the source_major_version property of this CreateDbFsuCollectionDetails.
            Allowed values for this property are: "DB_11204", "DB_121", "DB_122", "DB_18", "DB_19", "DB_23", "DB_26"
        :type source_major_version: str

        :param fleet_discovery:
            The value to assign to the fleet_discovery property of this CreateDbFsuCollectionDetails.
        :type fleet_discovery: oci.fleet_software_update.models.DbFleetDiscoveryDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'service_type': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'source_major_version': 'str',
            'fleet_discovery': 'DbFleetDiscoveryDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'service_type': 'serviceType',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'source_major_version': 'sourceMajorVersion',
            'fleet_discovery': 'fleetDiscovery'
        }
        self._display_name = None
        self._type = None
        self._service_type = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._source_major_version = None
        self._fleet_discovery = None
        self._type = 'DB'

    @property
    def source_major_version(self):
        """
        **[Required]** Gets the source_major_version of this CreateDbFsuCollectionDetails.
        Database Major Version of targets to be included in the Exadata Fleet Update Collection.
        https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbVersionSummary/ListDbVersions
        Only Database targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.

        Allowed values for this property are: "DB_11204", "DB_121", "DB_122", "DB_18", "DB_19", "DB_23", "DB_26"


        :return: The source_major_version of this CreateDbFsuCollectionDetails.
        :rtype: str
        """
        return self._source_major_version

    @source_major_version.setter
    def source_major_version(self, source_major_version):
        """
        Sets the source_major_version of this CreateDbFsuCollectionDetails.
        Database Major Version of targets to be included in the Exadata Fleet Update Collection.
        https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbVersionSummary/ListDbVersions
        Only Database targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.


        :param source_major_version: The source_major_version of this CreateDbFsuCollectionDetails.
        :type: str
        """
        allowed_values = ["DB_11204", "DB_121", "DB_122", "DB_18", "DB_19", "DB_23", "DB_26"]
        if not value_allowed_none_or_none_sentinel(source_major_version, allowed_values):
            raise ValueError(
                f"Invalid value for `source_major_version`, must be None or one of {allowed_values}"
            )
        self._source_major_version = source_major_version

    @property
    def fleet_discovery(self):
        """
        Gets the fleet_discovery of this CreateDbFsuCollectionDetails.

        :return: The fleet_discovery of this CreateDbFsuCollectionDetails.
        :rtype: oci.fleet_software_update.models.DbFleetDiscoveryDetails
        """
        return self._fleet_discovery

    @fleet_discovery.setter
    def fleet_discovery(self, fleet_discovery):
        """
        Sets the fleet_discovery of this CreateDbFsuCollectionDetails.

        :param fleet_discovery: The fleet_discovery of this CreateDbFsuCollectionDetails.
        :type: oci.fleet_software_update.models.DbFleetDiscoveryDetails
        """
        self._fleet_discovery = fleet_discovery

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
