# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_software_component_details import CreateSoftwareComponentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateGiSoftwareComponentDetails(CreateSoftwareComponentDetails):
    """
    Details to create 'GI' component in an Exadata software stack.
    """

    #: A constant which can be used with the source_major_version property of a CreateGiSoftwareComponentDetails.
    #: This constant has a value of "GI_18"
    SOURCE_MAJOR_VERSION_GI_18 = "GI_18"

    #: A constant which can be used with the source_major_version property of a CreateGiSoftwareComponentDetails.
    #: This constant has a value of "GI_19"
    SOURCE_MAJOR_VERSION_GI_19 = "GI_19"

    #: A constant which can be used with the source_major_version property of a CreateGiSoftwareComponentDetails.
    #: This constant has a value of "GI_23"
    SOURCE_MAJOR_VERSION_GI_23 = "GI_23"

    #: A constant which can be used with the source_major_version property of a CreateGiSoftwareComponentDetails.
    #: This constant has a value of "GI_26"
    SOURCE_MAJOR_VERSION_GI_26 = "GI_26"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateGiSoftwareComponentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateGiSoftwareComponentDetails.component_type` attribute
        of this class is ``GI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_type:
            The value to assign to the component_type property of this CreateGiSoftwareComponentDetails.
            Allowed values for this property are: "GI", "GUEST_OS"
        :type component_type: str

        :param source_major_version:
            The value to assign to the source_major_version property of this CreateGiSoftwareComponentDetails.
            Allowed values for this property are: "GI_18", "GI_19", "GI_23", "GI_26"
        :type source_major_version: str

        :param fleet_discovery:
            The value to assign to the fleet_discovery property of this CreateGiSoftwareComponentDetails.
        :type fleet_discovery: oci.fleet_software_update.models.GiFleetDiscoveryDetails

        """
        self.swagger_types = {
            'component_type': 'str',
            'source_major_version': 'str',
            'fleet_discovery': 'GiFleetDiscoveryDetails'
        }
        self.attribute_map = {
            'component_type': 'componentType',
            'source_major_version': 'sourceMajorVersion',
            'fleet_discovery': 'fleetDiscovery'
        }
        self._component_type = None
        self._source_major_version = None
        self._fleet_discovery = None
        self._component_type = 'GI'

    @property
    def source_major_version(self):
        """
        **[Required]** Gets the source_major_version of this CreateGiSoftwareComponentDetails.
        Grid Infrastructure Major Version of targets to be included in the Exadata Fleet Update Collection.
        Only GI targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.

        Allowed values for this property are: "GI_18", "GI_19", "GI_23", "GI_26"


        :return: The source_major_version of this CreateGiSoftwareComponentDetails.
        :rtype: str
        """
        return self._source_major_version

    @source_major_version.setter
    def source_major_version(self, source_major_version):
        """
        Sets the source_major_version of this CreateGiSoftwareComponentDetails.
        Grid Infrastructure Major Version of targets to be included in the Exadata Fleet Update Collection.
        Only GI targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.


        :param source_major_version: The source_major_version of this CreateGiSoftwareComponentDetails.
        :type: str
        """
        allowed_values = ["GI_18", "GI_19", "GI_23", "GI_26"]
        if not value_allowed_none_or_none_sentinel(source_major_version, allowed_values):
            raise ValueError(
                f"Invalid value for `source_major_version`, must be None or one of {allowed_values}"
            )
        self._source_major_version = source_major_version

    @property
    def fleet_discovery(self):
        """
        Gets the fleet_discovery of this CreateGiSoftwareComponentDetails.

        :return: The fleet_discovery of this CreateGiSoftwareComponentDetails.
        :rtype: oci.fleet_software_update.models.GiFleetDiscoveryDetails
        """
        return self._fleet_discovery

    @fleet_discovery.setter
    def fleet_discovery(self, fleet_discovery):
        """
        Sets the fleet_discovery of this CreateGiSoftwareComponentDetails.

        :param fleet_discovery: The fleet_discovery of this CreateGiSoftwareComponentDetails.
        :type: oci.fleet_software_update.models.GiFleetDiscoveryDetails
        """
        self._fleet_discovery = fleet_discovery

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
