# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_software_component_details import CreateSoftwareComponentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateGuestOsSoftwareComponentDetails(CreateSoftwareComponentDetails):
    """
    Details to create 'GUEST_OS' component in an Exadata software stack.
    """

    #: A constant which can be used with the source_major_version property of a CreateGuestOsSoftwareComponentDetails.
    #: This constant has a value of "EXA_OL_5"
    SOURCE_MAJOR_VERSION_EXA_OL_5 = "EXA_OL_5"

    #: A constant which can be used with the source_major_version property of a CreateGuestOsSoftwareComponentDetails.
    #: This constant has a value of "EXA_OL_6"
    SOURCE_MAJOR_VERSION_EXA_OL_6 = "EXA_OL_6"

    #: A constant which can be used with the source_major_version property of a CreateGuestOsSoftwareComponentDetails.
    #: This constant has a value of "EXA_OL_7"
    SOURCE_MAJOR_VERSION_EXA_OL_7 = "EXA_OL_7"

    #: A constant which can be used with the source_major_version property of a CreateGuestOsSoftwareComponentDetails.
    #: This constant has a value of "EXA_OL_8"
    SOURCE_MAJOR_VERSION_EXA_OL_8 = "EXA_OL_8"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateGuestOsSoftwareComponentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateGuestOsSoftwareComponentDetails.component_type` attribute
        of this class is ``GUEST_OS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_type:
            The value to assign to the component_type property of this CreateGuestOsSoftwareComponentDetails.
            Allowed values for this property are: "GI", "GUEST_OS"
        :type component_type: str

        :param source_major_version:
            The value to assign to the source_major_version property of this CreateGuestOsSoftwareComponentDetails.
            Allowed values for this property are: "EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8"
        :type source_major_version: str

        :param fleet_discovery:
            The value to assign to the fleet_discovery property of this CreateGuestOsSoftwareComponentDetails.
        :type fleet_discovery: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails

        """
        self.swagger_types = {
            'component_type': 'str',
            'source_major_version': 'str',
            'fleet_discovery': 'GuestOsFleetDiscoveryDetails'
        }
        self.attribute_map = {
            'component_type': 'componentType',
            'source_major_version': 'sourceMajorVersion',
            'fleet_discovery': 'fleetDiscovery'
        }
        self._component_type = None
        self._source_major_version = None
        self._fleet_discovery = None
        self._component_type = 'GUEST_OS'

    @property
    def source_major_version(self):
        """
        **[Required]** Gets the source_major_version of this CreateGuestOsSoftwareComponentDetails.
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in an Exadata Fleet Update Collection.
        Major Versions of Exadata Software are demarcated by the underlying Oracle Linux OS version.
        For more details, refer to `Oracle document 2075007.1`__

        __ https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html

        Allowed values for this property are: "EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8"


        :return: The source_major_version of this CreateGuestOsSoftwareComponentDetails.
        :rtype: str
        """
        return self._source_major_version

    @source_major_version.setter
    def source_major_version(self, source_major_version):
        """
        Sets the source_major_version of this CreateGuestOsSoftwareComponentDetails.
        Major version of Exadata Image (Guest OS) release for Exadata VM Cluster targets to be included in an Exadata Fleet Update Collection.
        Major Versions of Exadata Software are demarcated by the underlying Oracle Linux OS version.
        For more details, refer to `Oracle document 2075007.1`__

        __ https://support.oracle.com/knowledge/Oracle%20Database%20Products/2075007_1.html


        :param source_major_version: The source_major_version of this CreateGuestOsSoftwareComponentDetails.
        :type: str
        """
        allowed_values = ["EXA_OL_5", "EXA_OL_6", "EXA_OL_7", "EXA_OL_8"]
        if not value_allowed_none_or_none_sentinel(source_major_version, allowed_values):
            raise ValueError(
                f"Invalid value for `source_major_version`, must be None or one of {allowed_values}"
            )
        self._source_major_version = source_major_version

    @property
    def fleet_discovery(self):
        """
        Gets the fleet_discovery of this CreateGuestOsSoftwareComponentDetails.

        :return: The fleet_discovery of this CreateGuestOsSoftwareComponentDetails.
        :rtype: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails
        """
        return self._fleet_discovery

    @fleet_discovery.setter
    def fleet_discovery(self, fleet_discovery):
        """
        Sets the fleet_discovery of this CreateGuestOsSoftwareComponentDetails.

        :param fleet_discovery: The fleet_discovery of this CreateGuestOsSoftwareComponentDetails.
        :type: oci.fleet_software_update.models.GuestOsFleetDiscoveryDetails
        """
        self._fleet_discovery = fleet_discovery

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
