# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .target_details import TargetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseTargetSummary(TargetDetails):
    """
    Details of a Database target member of a Exadata Fleet Update Collection.
    Stored references of the resource documented in
    https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/Database/
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseTargetSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.DatabaseTargetSummary.entity_type` attribute
        of this class is ``DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this DatabaseTargetSummary.
            Allowed values for this property are: "DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER"
        :type entity_type: str

        :param id:
            The value to assign to the id property of this DatabaseTargetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DatabaseTargetSummary.
        :type compartment_id: str

        :param db_home_id:
            The value to assign to the db_home_id property of this DatabaseTargetSummary.
        :type db_home_id: str

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this DatabaseTargetSummary.
        :type vm_cluster_id: str

        :param infrastructure_id:
            The value to assign to the infrastructure_id property of this DatabaseTargetSummary.
        :type infrastructure_id: str

        :param software_image_id:
            The value to assign to the software_image_id property of this DatabaseTargetSummary.
        :type software_image_id: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'db_home_id': 'str',
            'vm_cluster_id': 'str',
            'infrastructure_id': 'str',
            'software_image_id': 'str'
        }
        self.attribute_map = {
            'entity_type': 'entityType',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'db_home_id': 'dbHomeId',
            'vm_cluster_id': 'vmClusterId',
            'infrastructure_id': 'infrastructureId',
            'software_image_id': 'softwareImageId'
        }
        self._entity_type = None
        self._id = None
        self._compartment_id = None
        self._db_home_id = None
        self._vm_cluster_id = None
        self._infrastructure_id = None
        self._software_image_id = None
        self._entity_type = 'DATABASE'

    @property
    def db_home_id(self):
        """
        Gets the db_home_id of this DatabaseTargetSummary.
        OCID of the database home.


        :return: The db_home_id of this DatabaseTargetSummary.
        :rtype: str
        """
        return self._db_home_id

    @db_home_id.setter
    def db_home_id(self, db_home_id):
        """
        Sets the db_home_id of this DatabaseTargetSummary.
        OCID of the database home.


        :param db_home_id: The db_home_id of this DatabaseTargetSummary.
        :type: str
        """
        self._db_home_id = db_home_id

    @property
    def vm_cluster_id(self):
        """
        Gets the vm_cluster_id of this DatabaseTargetSummary.
        OCID of the related VM Cluster or Cloud VM Cluster.


        :return: The vm_cluster_id of this DatabaseTargetSummary.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this DatabaseTargetSummary.
        OCID of the related VM Cluster or Cloud VM Cluster.


        :param vm_cluster_id: The vm_cluster_id of this DatabaseTargetSummary.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def infrastructure_id(self):
        """
        Gets the infrastructure_id of this DatabaseTargetSummary.
        OCID of the related Exadata Infrastructure or Cloud Exadata Infrastructure resource.


        :return: The infrastructure_id of this DatabaseTargetSummary.
        :rtype: str
        """
        return self._infrastructure_id

    @infrastructure_id.setter
    def infrastructure_id(self, infrastructure_id):
        """
        Sets the infrastructure_id of this DatabaseTargetSummary.
        OCID of the related Exadata Infrastructure or Cloud Exadata Infrastructure resource.


        :param infrastructure_id: The infrastructure_id of this DatabaseTargetSummary.
        :type: str
        """
        self._infrastructure_id = infrastructure_id

    @property
    def software_image_id(self):
        """
        Gets the software_image_id of this DatabaseTargetSummary.
        OCID of the Database sofware image.


        :return: The software_image_id of this DatabaseTargetSummary.
        :rtype: str
        """
        return self._software_image_id

    @software_image_id.setter
    def software_image_id(self, software_image_id):
        """
        Sets the software_image_id of this DatabaseTargetSummary.
        OCID of the Database sofware image.


        :param software_image_id: The software_image_id of this DatabaseTargetSummary.
        :type: str
        """
        self._software_image_id = software_image_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
