# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsFleetDiscoveryFilter(object):
    """
    Discover Exadata VM Cluster targets for a 'GUEST_OS' collection by querying `OCI Search Service`__ using specified filters.

    __ https://docs.cloud.oracle.com/Content/Search/Concepts/queryoverview.htm
    """

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "COMPARTMENT_ID"
    TYPE_COMPARTMENT_ID = "COMPARTMENT_ID"

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "VERSION"
    TYPE_VERSION = "VERSION"

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "EXADATA_RELEASE_VERSION"
    TYPE_EXADATA_RELEASE_VERSION = "EXADATA_RELEASE_VERSION"

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "FREEFORM_TAG"
    TYPE_FREEFORM_TAG = "FREEFORM_TAG"

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "DEFINED_TAG"
    TYPE_DEFINED_TAG = "DEFINED_TAG"

    #: A constant which can be used with the type property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "RESOURCE_ID"
    TYPE_RESOURCE_ID = "RESOURCE_ID"

    #: A constant which can be used with the mode property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "INCLUDE"
    MODE_INCLUDE = "INCLUDE"

    #: A constant which can be used with the mode property of a GuestOsFleetDiscoveryFilter.
    #: This constant has a value of "EXCLUDE"
    MODE_EXCLUDE = "EXCLUDE"

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsFleetDiscoveryFilter object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.GuestOsVersionFilter`
        * :class:`~oci.fleet_software_update.models.GuestOsExadataReleaseVersionFilter`
        * :class:`~oci.fleet_software_update.models.GuestOsFreeformTagsFilter`
        * :class:`~oci.fleet_software_update.models.GuestOsDefinedTagsFilter`
        * :class:`~oci.fleet_software_update.models.GuestOsCompartmentIdFilter`
        * :class:`~oci.fleet_software_update.models.GuestOsResourceIdFilter`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuestOsFleetDiscoveryFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param mode:
            The value to assign to the mode property of this GuestOsFleetDiscoveryFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mode: str

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode'
        }
        self._type = None
        self._mode = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'VERSION':
            return 'GuestOsVersionFilter'

        if type == 'EXADATA_RELEASE_VERSION':
            return 'GuestOsExadataReleaseVersionFilter'

        if type == 'FREEFORM_TAG':
            return 'GuestOsFreeformTagsFilter'

        if type == 'DEFINED_TAG':
            return 'GuestOsDefinedTagsFilter'

        if type == 'COMPARTMENT_ID':
            return 'GuestOsCompartmentIdFilter'

        if type == 'RESOURCE_ID':
            return 'GuestOsResourceIdFilter'
        else:
            return 'GuestOsFleetDiscoveryFilter'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this GuestOsFleetDiscoveryFilter.
        Filters supported for searching Exadata VM Cluster targets for a 'GUEST_OS' collection.

        Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this GuestOsFleetDiscoveryFilter.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this GuestOsFleetDiscoveryFilter.
        Filters supported for searching Exadata VM Cluster targets for a 'GUEST_OS' collection.


        :param type: The type of this GuestOsFleetDiscoveryFilter.
        :type: str
        """
        allowed_values = ["COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def mode(self):
        """
        Gets the mode of this GuestOsFleetDiscoveryFilter.
        INCLUDE or EXCLUDE the filter results when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
        Supported only for RESOURCE_ID filter.

        Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mode of this GuestOsFleetDiscoveryFilter.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this GuestOsFleetDiscoveryFilter.
        INCLUDE or EXCLUDE the filter results when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
        Supported only for RESOURCE_ID filter.


        :param mode: The mode of this GuestOsFleetDiscoveryFilter.
        :type: str
        """
        allowed_values = ["INCLUDE", "EXCLUDE"]
        if not value_allowed_none_or_none_sentinel(mode, allowed_values):
            mode = 'UNKNOWN_ENUM_VALUE'
        self._mode = mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
