# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .goal_software_component_details import GoalSoftwareComponentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsGoalSoftwareComponentDetails(GoalSoftwareComponentDetails):
    """
    Details of goal version for 'GUEST_OS' component in an 'EXADB_STACK' type Exadata Fleet Update Collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsGoalSoftwareComponentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsGoalSoftwareComponentDetails.component_type` attribute
        of this class is ``GUEST_OS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_type:
            The value to assign to the component_type property of this GuestOsGoalSoftwareComponentDetails.
            Allowed values for this property are: "GI", "GUEST_OS"
        :type component_type: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this GuestOsGoalSoftwareComponentDetails.
        :type goal_version_details: oci.fleet_software_update.models.GuestOsGoalVersionDetails

        """
        self.swagger_types = {
            'component_type': 'str',
            'goal_version_details': 'GuestOsGoalVersionDetails'
        }
        self.attribute_map = {
            'component_type': 'componentType',
            'goal_version_details': 'goalVersionDetails'
        }
        self._component_type = None
        self._goal_version_details = None
        self._component_type = 'GUEST_OS'

    @property
    def goal_version_details(self):
        """
        **[Required]** Gets the goal_version_details of this GuestOsGoalSoftwareComponentDetails.

        :return: The goal_version_details of this GuestOsGoalSoftwareComponentDetails.
        :rtype: oci.fleet_software_update.models.GuestOsGoalVersionDetails
        """
        return self._goal_version_details

    @goal_version_details.setter
    def goal_version_details(self, goal_version_details):
        """
        Sets the goal_version_details of this GuestOsGoalSoftwareComponentDetails.

        :param goal_version_details: The goal_version_details of this GuestOsGoalSoftwareComponentDetails.
        :type: oci.fleet_software_update.models.GuestOsGoalVersionDetails
        """
        self._goal_version_details = goal_version_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
