# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateGenerativeAiPrivateEndpointDetails(object):
    """
    The details required to update a Generative AI private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateGenerativeAiPrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type display_name: str

        :param dns_prefix:
            The value to assign to the dns_prefix property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type dns_prefix: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type nsg_ids: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateGenerativeAiPrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'display_name': 'str',
            'dns_prefix': 'str',
            'nsg_ids': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'description': 'description',
            'display_name': 'displayName',
            'dns_prefix': 'dnsPrefix',
            'nsg_ids': 'nsgIds',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._description = None
        self._display_name = None
        self._dns_prefix = None
        self._nsg_ids = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateGenerativeAiPrivateEndpointDetails.
        A user friendly description. Avoid entering confidential information.


        :return: The description of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateGenerativeAiPrivateEndpointDetails.
        A user friendly description. Avoid entering confidential information.


        :param description: The description of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateGenerativeAiPrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :return: The display_name of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateGenerativeAiPrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :param display_name: The display_name of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def dns_prefix(self):
        """
        Gets the dns_prefix of this UpdateGenerativeAiPrivateEndpointDetails.
        dnsPrefix of the private endpoint FQDN.


        :return: The dns_prefix of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._dns_prefix

    @dns_prefix.setter
    def dns_prefix(self, dns_prefix):
        """
        Sets the dns_prefix of this UpdateGenerativeAiPrivateEndpointDetails.
        dnsPrefix of the private endpoint FQDN.


        :param dns_prefix: The dns_prefix of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._dns_prefix = dns_prefix

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateGenerativeAiPrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.


        :return: The nsg_ids of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateGenerativeAiPrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.


        :param nsg_ids: The nsg_ids of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateGenerativeAiPrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
