# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataIngestionJobSummary(object):
    """
    Summary information about a data ingestion job.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataIngestionJobSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DataIngestionJobSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DataIngestionJobSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DataIngestionJobSummary.
        :type description: str

        :param data_source_id:
            The value to assign to the data_source_id property of this DataIngestionJobSummary.
        :type data_source_id: str

        :param data_ingestion_job_type:
            The value to assign to the data_ingestion_job_type property of this DataIngestionJobSummary.
        :type data_ingestion_job_type: oci.generative_ai_agent.models.DataIngestionJobType

        :param data_ingestion_job_statistics:
            The value to assign to the data_ingestion_job_statistics property of this DataIngestionJobSummary.
        :type data_ingestion_job_statistics: oci.generative_ai_agent.models.DataIngestionJobStatistics

        :param compartment_id:
            The value to assign to the compartment_id property of this DataIngestionJobSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this DataIngestionJobSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DataIngestionJobSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DataIngestionJobSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DataIngestionJobSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DataIngestionJobSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DataIngestionJobSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DataIngestionJobSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'data_source_id': 'str',
            'data_ingestion_job_type': 'DataIngestionJobType',
            'data_ingestion_job_statistics': 'DataIngestionJobStatistics',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'data_source_id': 'dataSourceId',
            'data_ingestion_job_type': 'dataIngestionJobType',
            'data_ingestion_job_statistics': 'dataIngestionJobStatistics',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._data_source_id = None
        self._data_ingestion_job_type = None
        self._data_ingestion_job_statistics = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DataIngestionJobSummary.
        The `OCID`__ of the data ingestion job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DataIngestionJobSummary.
        The `OCID`__ of the data ingestion job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this DataIngestionJobSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DataIngestionJobSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DataIngestionJobSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this DataIngestionJobSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DataIngestionJobSummary.
        A user-friendly description of the DataSource.


        :return: The description of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DataIngestionJobSummary.
        A user-friendly description of the DataSource.


        :param description: The description of this DataIngestionJobSummary.
        :type: str
        """
        self._description = description

    @property
    def data_source_id(self):
        """
        **[Required]** Gets the data_source_id of this DataIngestionJobSummary.
        The `OCID`__ of the parent DataSource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The data_source_id of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """
        Sets the data_source_id of this DataIngestionJobSummary.
        The `OCID`__ of the parent DataSource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param data_source_id: The data_source_id of this DataIngestionJobSummary.
        :type: str
        """
        self._data_source_id = data_source_id

    @property
    def data_ingestion_job_type(self):
        """
        **[Required]** Gets the data_ingestion_job_type of this DataIngestionJobSummary.

        :return: The data_ingestion_job_type of this DataIngestionJobSummary.
        :rtype: oci.generative_ai_agent.models.DataIngestionJobType
        """
        return self._data_ingestion_job_type

    @data_ingestion_job_type.setter
    def data_ingestion_job_type(self, data_ingestion_job_type):
        """
        Sets the data_ingestion_job_type of this DataIngestionJobSummary.

        :param data_ingestion_job_type: The data_ingestion_job_type of this DataIngestionJobSummary.
        :type: oci.generative_ai_agent.models.DataIngestionJobType
        """
        self._data_ingestion_job_type = data_ingestion_job_type

    @property
    def data_ingestion_job_statistics(self):
        """
        **[Required]** Gets the data_ingestion_job_statistics of this DataIngestionJobSummary.

        :return: The data_ingestion_job_statistics of this DataIngestionJobSummary.
        :rtype: oci.generative_ai_agent.models.DataIngestionJobStatistics
        """
        return self._data_ingestion_job_statistics

    @data_ingestion_job_statistics.setter
    def data_ingestion_job_statistics(self, data_ingestion_job_statistics):
        """
        Sets the data_ingestion_job_statistics of this DataIngestionJobSummary.

        :param data_ingestion_job_statistics: The data_ingestion_job_statistics of this DataIngestionJobSummary.
        :type: oci.generative_ai_agent.models.DataIngestionJobStatistics
        """
        self._data_ingestion_job_statistics = data_ingestion_job_statistics

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DataIngestionJobSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DataIngestionJobSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DataIngestionJobSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DataIngestionJobSummary.
        The date and time the data ingestion job was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DataIngestionJobSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DataIngestionJobSummary.
        The date and time the data ingestion job was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DataIngestionJobSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DataIngestionJobSummary.
        The date and time the data ingestion job was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DataIngestionJobSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DataIngestionJobSummary.
        The date and time the data ingestion job was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DataIngestionJobSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DataIngestionJobSummary.
        The current state of the data ingestion job.


        :return: The lifecycle_state of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DataIngestionJobSummary.
        The current state of the data ingestion job.


        :param lifecycle_state: The lifecycle_state of this DataIngestionJobSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DataIngestionJobSummary.
        A message that describes the current state of the data ingestion job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this DataIngestionJobSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DataIngestionJobSummary.
        A message that describes the current state of the data ingestion job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this DataIngestionJobSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this DataIngestionJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DataIngestionJobSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DataIngestionJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DataIngestionJobSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this DataIngestionJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DataIngestionJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DataIngestionJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DataIngestionJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DataIngestionJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DataIngestionJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DataIngestionJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DataIngestionJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
