# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_config import ToolConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FunctionCallingToolConfig(ToolConfig):
    """
    The configuration for Function calling Tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FunctionCallingToolConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.FunctionCallingToolConfig.tool_config_type` attribute
        of this class is ``FUNCTION_CALLING_TOOL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this FunctionCallingToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG"
        :type tool_config_type: str

        :param function:
            The value to assign to the function property of this FunctionCallingToolConfig.
        :type function: oci.generative_ai_agent.models.Function

        """
        self.swagger_types = {
            'tool_config_type': 'str',
            'function': 'Function'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType',
            'function': 'function'
        }
        self._tool_config_type = None
        self._function = None
        self._tool_config_type = 'FUNCTION_CALLING_TOOL_CONFIG'

    @property
    def function(self):
        """
        **[Required]** Gets the function of this FunctionCallingToolConfig.

        :return: The function of this FunctionCallingToolConfig.
        :rtype: oci.generative_ai_agent.models.Function
        """
        return self._function

    @function.setter
    def function(self, function):
        """
        Sets the function of this FunctionCallingToolConfig.

        :param function: The function of this FunctionCallingToolConfig.
        :type: oci.generative_ai_agent.models.Function
        """
        self._function = function

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
