# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .http_endpoint_auth_config import HttpEndpointAuthConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointIdcsAuthConfig(HttpEndpointAuthConfig):
    """
    Specifies authentication using Oracle Identity Cloud Service (IDCS), leveraging OAuth 2.0 for token-based authentication.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointIdcsAuthConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.HttpEndpointIdcsAuthConfig.http_endpoint_auth_config_type` attribute
        of this class is ``HTTP_ENDPOINT_IDCS_AUTH_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_config_type:
            The value to assign to the http_endpoint_auth_config_type property of this HttpEndpointIdcsAuthConfig.
            Allowed values for this property are: "HTTP_ENDPOINT_NO_AUTH_CONFIG", "HTTP_ENDPOINT_DELEGATED_BEARER_AUTH_CONFIG", "HTTP_ENDPOINT_OCI_RESOURCE_PRINCIPAL_AUTH_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_CONFIG"
        :type http_endpoint_auth_config_type: str

        :param idcs_secret:
            The value to assign to the idcs_secret property of this HttpEndpointIdcsAuthConfig.
        :type idcs_secret: oci.generative_ai_agent.models.IdcsSecret

        """
        self.swagger_types = {
            'http_endpoint_auth_config_type': 'str',
            'idcs_secret': 'IdcsSecret'
        }
        self.attribute_map = {
            'http_endpoint_auth_config_type': 'httpEndpointAuthConfigType',
            'idcs_secret': 'idcsSecret'
        }
        self._http_endpoint_auth_config_type = None
        self._idcs_secret = None
        self._http_endpoint_auth_config_type = 'HTTP_ENDPOINT_IDCS_AUTH_CONFIG'

    @property
    def idcs_secret(self):
        """
        **[Required]** Gets the idcs_secret of this HttpEndpointIdcsAuthConfig.

        :return: The idcs_secret of this HttpEndpointIdcsAuthConfig.
        :rtype: oci.generative_ai_agent.models.IdcsSecret
        """
        return self._idcs_secret

    @idcs_secret.setter
    def idcs_secret(self, idcs_secret):
        """
        Sets the idcs_secret of this HttpEndpointIdcsAuthConfig.

        :param idcs_secret: The idcs_secret of this HttpEndpointIdcsAuthConfig.
        :type: oci.generative_ai_agent.models.IdcsSecret
        """
        self._idcs_secret = idcs_secret

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
