# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_config import ToolConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointToolConfig(ToolConfig):
    """
    The configuration for HTTP endpoint Tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointToolConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.HttpEndpointToolConfig.tool_config_type` attribute
        of this class is ``HTTP_ENDPOINT_TOOL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this HttpEndpointToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG"
        :type tool_config_type: str

        :param api_schema:
            The value to assign to the api_schema property of this HttpEndpointToolConfig.
        :type api_schema: oci.generative_ai_agent.models.ApiSchemaInputLocation

        :param subnet_id:
            The value to assign to the subnet_id property of this HttpEndpointToolConfig.
        :type subnet_id: str

        :param http_endpoint_auth_config:
            The value to assign to the http_endpoint_auth_config property of this HttpEndpointToolConfig.
        :type http_endpoint_auth_config: oci.generative_ai_agent.models.HttpEndpointAuthConfig

        """
        self.swagger_types = {
            'tool_config_type': 'str',
            'api_schema': 'ApiSchemaInputLocation',
            'subnet_id': 'str',
            'http_endpoint_auth_config': 'HttpEndpointAuthConfig'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType',
            'api_schema': 'apiSchema',
            'subnet_id': 'subnetId',
            'http_endpoint_auth_config': 'httpEndpointAuthConfig'
        }
        self._tool_config_type = None
        self._api_schema = None
        self._subnet_id = None
        self._http_endpoint_auth_config = None
        self._tool_config_type = 'HTTP_ENDPOINT_TOOL_CONFIG'

    @property
    def api_schema(self):
        """
        **[Required]** Gets the api_schema of this HttpEndpointToolConfig.

        :return: The api_schema of this HttpEndpointToolConfig.
        :rtype: oci.generative_ai_agent.models.ApiSchemaInputLocation
        """
        return self._api_schema

    @api_schema.setter
    def api_schema(self, api_schema):
        """
        Sets the api_schema of this HttpEndpointToolConfig.

        :param api_schema: The api_schema of this HttpEndpointToolConfig.
        :type: oci.generative_ai_agent.models.ApiSchemaInputLocation
        """
        self._api_schema = api_schema

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this HttpEndpointToolConfig.
        The subnet ID from agent developer tenancy through which the egress is going to be routed.


        :return: The subnet_id of this HttpEndpointToolConfig.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this HttpEndpointToolConfig.
        The subnet ID from agent developer tenancy through which the egress is going to be routed.


        :param subnet_id: The subnet_id of this HttpEndpointToolConfig.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def http_endpoint_auth_config(self):
        """
        **[Required]** Gets the http_endpoint_auth_config of this HttpEndpointToolConfig.

        :return: The http_endpoint_auth_config of this HttpEndpointToolConfig.
        :rtype: oci.generative_ai_agent.models.HttpEndpointAuthConfig
        """
        return self._http_endpoint_auth_config

    @http_endpoint_auth_config.setter
    def http_endpoint_auth_config(self, http_endpoint_auth_config):
        """
        Sets the http_endpoint_auth_config of this HttpEndpointToolConfig.

        :param http_endpoint_auth_config: The http_endpoint_auth_config of this HttpEndpointToolConfig.
        :type: oci.generative_ai_agent.models.HttpEndpointAuthConfig
        """
        self._http_endpoint_auth_config = http_endpoint_auth_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
