# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlmCustomization(object):
    """
    Configuration to customize LLM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LlmCustomization object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instruction:
            The value to assign to the instruction property of this LlmCustomization.
        :type instruction: str

        """
        self.swagger_types = {
            'instruction': 'str'
        }
        self.attribute_map = {
            'instruction': 'instruction'
        }
        self._instruction = None

    @property
    def instruction(self):
        """
        Gets the instruction of this LlmCustomization.
        If specified, the default instruction is replaced with provided instruction.


        :return: The instruction of this LlmCustomization.
        :rtype: str
        """
        return self._instruction

    @instruction.setter
    def instruction(self, instruction):
        """
        Sets the instruction of this LlmCustomization.
        If specified, the default instruction is replaced with provided instruction.


        :param instruction: The instruction of this LlmCustomization.
        :type: str
        """
        self._instruction = instruction

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
