# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BaseChatResponse(object):
    """
    The base class that creates the chat response.
    """

    #: A constant which can be used with the api_format property of a BaseChatResponse.
    #: This constant has a value of "COHERE"
    API_FORMAT_COHERE = "COHERE"

    #: A constant which can be used with the api_format property of a BaseChatResponse.
    #: This constant has a value of "GENERIC"
    API_FORMAT_GENERIC = "GENERIC"

    def __init__(self, **kwargs):
        """
        Initializes a new BaseChatResponse object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_inference.models.GenericChatResponse`
        * :class:`~oci.generative_ai_inference.models.CohereChatResponse`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this BaseChatResponse.
            Allowed values for this property are: "COHERE", "GENERIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type api_format: str

        """
        self.swagger_types = {
            'api_format': 'str'
        }
        self.attribute_map = {
            'api_format': 'apiFormat'
        }
        self._api_format = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['apiFormat']

        if type == 'GENERIC':
            return 'GenericChatResponse'

        if type == 'COHERE':
            return 'CohereChatResponse'
        else:
            return 'BaseChatResponse'

    @property
    def api_format(self):
        """
        **[Required]** Gets the api_format of this BaseChatResponse.
        The API format for the model's response.

        Allowed values for this property are: "COHERE", "GENERIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The api_format of this BaseChatResponse.
        :rtype: str
        """
        return self._api_format

    @api_format.setter
    def api_format(self, api_format):
        """
        Sets the api_format of this BaseChatResponse.
        The API format for the model's response.


        :param api_format: The api_format of this BaseChatResponse.
        :type: str
        """
        allowed_values = ["COHERE", "GENERIC"]
        if not value_allowed_none_or_none_sentinel(api_format, allowed_values):
            api_format = 'UNKNOWN_ENUM_VALUE'
        self._api_format = api_format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
