# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .cohere_message import CohereMessage
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereToolMessage(CohereMessage):
    """
    A message that represents a single chat dialog as TOOL role.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereToolMessage object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereToolMessage.role` attribute
        of this class is ``TOOL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role:
            The value to assign to the role property of this CohereToolMessage.
            Allowed values for this property are: "CHATBOT", "USER", "SYSTEM", "TOOL"
        :type role: str

        :param tool_results:
            The value to assign to the tool_results property of this CohereToolMessage.
        :type tool_results: list[oci.generative_ai_inference.models.CohereToolResult]

        """
        self.swagger_types = {
            'role': 'str',
            'tool_results': 'list[CohereToolResult]'
        }
        self.attribute_map = {
            'role': 'role',
            'tool_results': 'toolResults'
        }
        self._role = None
        self._tool_results = None
        self._role = 'TOOL'

    @property
    def tool_results(self):
        """
        **[Required]** Gets the tool_results of this CohereToolMessage.
        A list of results from invoking tools recommended by the model in the previous chat turn.


        :return: The tool_results of this CohereToolMessage.
        :rtype: list[oci.generative_ai_inference.models.CohereToolResult]
        """
        return self._tool_results

    @tool_results.setter
    def tool_results(self, tool_results):
        """
        Sets the tool_results of this CohereToolMessage.
        A list of results from invoking tools recommended by the model in the previous chat turn.


        :param tool_results: The tool_results of this CohereToolMessage.
        :type: list[oci.generative_ai_inference.models.CohereToolResult]
        """
        self._tool_results = tool_results

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
