# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EmbedTextResult(object):
    """
    The generated embedded result to return.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EmbedTextResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this EmbedTextResult.
        :type id: str

        :param inputs:
            The value to assign to the inputs property of this EmbedTextResult.
        :type inputs: list[str]

        :param embeddings:
            The value to assign to the embeddings property of this EmbedTextResult.
        :type embeddings: list[list[float]]

        :param model_id:
            The value to assign to the model_id property of this EmbedTextResult.
        :type model_id: str

        :param model_version:
            The value to assign to the model_version property of this EmbedTextResult.
        :type model_version: str

        :param usage:
            The value to assign to the usage property of this EmbedTextResult.
        :type usage: oci.generative_ai_inference.models.Usage

        """
        self.swagger_types = {
            'id': 'str',
            'inputs': 'list[str]',
            'embeddings': 'list[list[float]]',
            'model_id': 'str',
            'model_version': 'str',
            'usage': 'Usage'
        }
        self.attribute_map = {
            'id': 'id',
            'inputs': 'inputs',
            'embeddings': 'embeddings',
            'model_id': 'modelId',
            'model_version': 'modelVersion',
            'usage': 'usage'
        }
        self._id = None
        self._inputs = None
        self._embeddings = None
        self._model_id = None
        self._model_version = None
        self._usage = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this EmbedTextResult.
        A unique identifier for the generated result.


        :return: The id of this EmbedTextResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EmbedTextResult.
        A unique identifier for the generated result.


        :param id: The id of this EmbedTextResult.
        :type: str
        """
        self._id = id

    @property
    def inputs(self):
        """
        Gets the inputs of this EmbedTextResult.
        The original inputs. Only present if \"isEcho\" is set to true.


        :return: The inputs of this EmbedTextResult.
        :rtype: list[str]
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """
        Sets the inputs of this EmbedTextResult.
        The original inputs. Only present if \"isEcho\" is set to true.


        :param inputs: The inputs of this EmbedTextResult.
        :type: list[str]
        """
        self._inputs = inputs

    @property
    def embeddings(self):
        """
        **[Required]** Gets the embeddings of this EmbedTextResult.
        The embeddings corresponding to inputs.


        :return: The embeddings of this EmbedTextResult.
        :rtype: list[list[float]]
        """
        return self._embeddings

    @embeddings.setter
    def embeddings(self, embeddings):
        """
        Sets the embeddings of this EmbedTextResult.
        The embeddings corresponding to inputs.


        :param embeddings: The embeddings of this EmbedTextResult.
        :type: list[list[float]]
        """
        self._embeddings = embeddings

    @property
    def model_id(self):
        """
        Gets the model_id of this EmbedTextResult.
        The OCID of the model used in this inference request.


        :return: The model_id of this EmbedTextResult.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this EmbedTextResult.
        The OCID of the model used in this inference request.


        :param model_id: The model_id of this EmbedTextResult.
        :type: str
        """
        self._model_id = model_id

    @property
    def model_version(self):
        """
        Gets the model_version of this EmbedTextResult.
        The version of the model.


        :return: The model_version of this EmbedTextResult.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this EmbedTextResult.
        The version of the model.


        :param model_version: The model_version of this EmbedTextResult.
        :type: str
        """
        self._model_version = model_version

    @property
    def usage(self):
        """
        Gets the usage of this EmbedTextResult.

        :return: The usage of this EmbedTextResult.
        :rtype: oci.generative_ai_inference.models.Usage
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """
        Sets the usage of this EmbedTextResult.

        :param usage: The usage of this EmbedTextResult.
        :type: oci.generative_ai_inference.models.Usage
        """
        self._usage = usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
