# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuardrailsResults(object):
    """
    The results of applying each guardrail.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuardrailsResults object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_moderation:
            The value to assign to the content_moderation property of this GuardrailsResults.
        :type content_moderation: oci.generative_ai_inference.models.ContentModerationResult

        :param personally_identifiable_information:
            The value to assign to the personally_identifiable_information property of this GuardrailsResults.
        :type personally_identifiable_information: list[oci.generative_ai_inference.models.PersonallyIdentifiableInformationResult]

        :param prompt_injection:
            The value to assign to the prompt_injection property of this GuardrailsResults.
        :type prompt_injection: oci.generative_ai_inference.models.PromptInjectionProtectionResult

        """
        self.swagger_types = {
            'content_moderation': 'ContentModerationResult',
            'personally_identifiable_information': 'list[PersonallyIdentifiableInformationResult]',
            'prompt_injection': 'PromptInjectionProtectionResult'
        }
        self.attribute_map = {
            'content_moderation': 'contentModeration',
            'personally_identifiable_information': 'personallyIdentifiableInformation',
            'prompt_injection': 'promptInjection'
        }
        self._content_moderation = None
        self._personally_identifiable_information = None
        self._prompt_injection = None

    @property
    def content_moderation(self):
        """
        Gets the content_moderation of this GuardrailsResults.

        :return: The content_moderation of this GuardrailsResults.
        :rtype: oci.generative_ai_inference.models.ContentModerationResult
        """
        return self._content_moderation

    @content_moderation.setter
    def content_moderation(self, content_moderation):
        """
        Sets the content_moderation of this GuardrailsResults.

        :param content_moderation: The content_moderation of this GuardrailsResults.
        :type: oci.generative_ai_inference.models.ContentModerationResult
        """
        self._content_moderation = content_moderation

    @property
    def personally_identifiable_information(self):
        """
        Gets the personally_identifiable_information of this GuardrailsResults.
        The result of PII detection


        :return: The personally_identifiable_information of this GuardrailsResults.
        :rtype: list[oci.generative_ai_inference.models.PersonallyIdentifiableInformationResult]
        """
        return self._personally_identifiable_information

    @personally_identifiable_information.setter
    def personally_identifiable_information(self, personally_identifiable_information):
        """
        Sets the personally_identifiable_information of this GuardrailsResults.
        The result of PII detection


        :param personally_identifiable_information: The personally_identifiable_information of this GuardrailsResults.
        :type: list[oci.generative_ai_inference.models.PersonallyIdentifiableInformationResult]
        """
        self._personally_identifiable_information = personally_identifiable_information

    @property
    def prompt_injection(self):
        """
        Gets the prompt_injection of this GuardrailsResults.

        :return: The prompt_injection of this GuardrailsResults.
        :rtype: oci.generative_ai_inference.models.PromptInjectionProtectionResult
        """
        return self._prompt_injection

    @prompt_injection.setter
    def prompt_injection(self, prompt_injection):
        """
        Sets the prompt_injection of this GuardrailsResults.

        :param prompt_injection: The prompt_injection of this GuardrailsResults.
        :type: oci.generative_ai_inference.models.PromptInjectionProtectionResult
        """
        self._prompt_injection = prompt_injection

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
