# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .guardrails_input import GuardrailsInput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuardrailsTextInput(GuardrailsInput):
    """
    Represents a single instance of text in the guardrails input.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuardrailsTextInput object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.GuardrailsTextInput.type` attribute
        of this class is ``TEXT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuardrailsTextInput.
            Allowed values for this property are: "TEXT"
        :type type: str

        :param content:
            The value to assign to the content property of this GuardrailsTextInput.
        :type content: str

        :param language_code:
            The value to assign to the language_code property of this GuardrailsTextInput.
        :type language_code: str

        """
        self.swagger_types = {
            'type': 'str',
            'content': 'str',
            'language_code': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'content': 'content',
            'language_code': 'languageCode'
        }
        self._type = None
        self._content = None
        self._language_code = None
        self._type = 'TEXT'

    @property
    def content(self):
        """
        Gets the content of this GuardrailsTextInput.
        The actual input data.


        :return: The content of this GuardrailsTextInput.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this GuardrailsTextInput.
        The actual input data.


        :param content: The content of this GuardrailsTextInput.
        :type: str
        """
        self._content = content

    @property
    def language_code(self):
        """
        Gets the language_code of this GuardrailsTextInput.
        The language code of the input text. example - en | es | en-US | zh-CN


        :return: The language_code of this GuardrailsTextInput.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this GuardrailsTextInput.
        The language code of the input text. example - en | es | en-US | zh-CN


        :param language_code: The language_code of this GuardrailsTextInput.
        :type: str
        """
        self._language_code = language_code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
