# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RerankTextResult(object):
    """
    The rerank response to return to the caller.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RerankTextResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RerankTextResult.
        :type id: str

        :param model_id:
            The value to assign to the model_id property of this RerankTextResult.
        :type model_id: str

        :param model_version:
            The value to assign to the model_version property of this RerankTextResult.
        :type model_version: str

        :param document_ranks:
            The value to assign to the document_ranks property of this RerankTextResult.
        :type document_ranks: list[oci.generative_ai_inference.models.DocumentRank]

        """
        self.swagger_types = {
            'id': 'str',
            'model_id': 'str',
            'model_version': 'str',
            'document_ranks': 'list[DocumentRank]'
        }
        self.attribute_map = {
            'id': 'id',
            'model_id': 'modelId',
            'model_version': 'modelVersion',
            'document_ranks': 'documentRanks'
        }
        self._id = None
        self._model_id = None
        self._model_version = None
        self._document_ranks = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RerankTextResult.
        A unique identifier for this `RerankResult`.


        :return: The id of this RerankTextResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RerankTextResult.
        A unique identifier for this `RerankResult`.


        :param id: The id of this RerankTextResult.
        :type: str
        """
        self._id = id

    @property
    def model_id(self):
        """
        Gets the model_id of this RerankTextResult.
        The OCID of the model used in the rerank request.


        :return: The model_id of this RerankTextResult.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this RerankTextResult.
        The OCID of the model used in the rerank request.


        :param model_id: The model_id of this RerankTextResult.
        :type: str
        """
        self._model_id = model_id

    @property
    def model_version(self):
        """
        Gets the model_version of this RerankTextResult.
        The version of the model.


        :return: The model_version of this RerankTextResult.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this RerankTextResult.
        The version of the model.


        :param model_version: The model_version of this RerankTextResult.
        :type: str
        """
        self._model_version = model_version

    @property
    def document_ranks(self):
        """
        **[Required]** Gets the document_ranks of this RerankTextResult.
        Top n documents with their index and relevance score.


        :return: The document_ranks of this RerankTextResult.
        :rtype: list[oci.generative_ai_inference.models.DocumentRank]
        """
        return self._document_ranks

    @document_ranks.setter
    def document_ranks(self, document_ranks):
        """
        Sets the document_ranks of this RerankTextResult.
        Top n documents with their index and relevance score.


        :param document_ranks: The document_ranks of this RerankTextResult.
        :type: list[oci.generative_ai_inference.models.DocumentRank]
        """
        self._document_ranks = document_ranks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
