# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrevalidatePayload(object):
    """
    Payload required to run prevalidation operation for create sharded database or patch sharded database, based on operation selected.
    """

    #: A constant which can be used with the operation property of a PrevalidatePayload.
    #: This constant has a value of "CREATE"
    OPERATION_CREATE = "CREATE"

    #: A constant which can be used with the operation property of a PrevalidatePayload.
    #: This constant has a value of "PATCH"
    OPERATION_PATCH = "PATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new PrevalidatePayload object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.globally_distributed_database.models.PrevalidatePatchPayload`
        * :class:`~oci.globally_distributed_database.models.PrevalidateCreatePayload`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation:
            The value to assign to the operation property of this PrevalidatePayload.
            Allowed values for this property are: "CREATE", "PATCH"
        :type operation: str

        """
        self.swagger_types = {
            'operation': 'str'
        }
        self.attribute_map = {
            'operation': 'operation'
        }
        self._operation = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['operation']

        if type == 'PATCH':
            return 'PrevalidatePatchPayload'

        if type == 'CREATE':
            return 'PrevalidateCreatePayload'
        else:
            return 'PrevalidatePayload'

    @property
    def operation(self):
        """
        **[Required]** Gets the operation of this PrevalidatePayload.
        The operation on sharded database that need to be pre-validated.

        Allowed values for this property are: "CREATE", "PATCH"


        :return: The operation of this PrevalidatePayload.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this PrevalidatePayload.
        The operation on sharded database that need to be pre-validated.


        :param operation: The operation of this PrevalidatePayload.
        :type: str
        """
        allowed_values = ["CREATE", "PATCH"]
        if not value_allowed_none_or_none_sentinel(operation, allowed_values):
            raise ValueError(
                f"Invalid value for `operation`, must be None or one of {allowed_values}"
            )
        self._operation = operation

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
