# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .connection import Connection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GooglePubSubConnection(Connection):
    """
    Represents the metadata of a Google PubSub Connection.
    """

    #: A constant which can be used with the technology_type property of a GooglePubSubConnection.
    #: This constant has a value of "GOOGLE_PUBSUB"
    TECHNOLOGY_TYPE_GOOGLE_PUBSUB = "GOOGLE_PUBSUB"

    def __init__(self, **kwargs):
        """
        Initializes a new GooglePubSubConnection object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.GooglePubSubConnection.connection_type` attribute
        of this class is ``GOOGLE_PUBSUB`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this GooglePubSubConnection.
            Allowed values for this property are: "GOLDENGATE", "KAFKA", "KAFKA_SCHEMA_REGISTRY", "MYSQL", "JAVA_MESSAGE_SERVICE", "MICROSOFT_SQLSERVER", "OCI_OBJECT_STORAGE", "ORACLE", "AZURE_DATA_LAKE_STORAGE", "POSTGRESQL", "AZURE_SYNAPSE_ANALYTICS", "SNOWFLAKE", "AMAZON_S3", "HDFS", "ORACLE_AI_DATA_PLATFORM", "ORACLE_NOSQL", "MONGODB", "AMAZON_KINESIS", "AMAZON_REDSHIFT", "DB2", "REDIS", "ELASTICSEARCH", "GENERIC", "GOOGLE_CLOUD_STORAGE", "GOOGLE_BIGQUERY", "DATABRICKS", "GOOGLE_PUBSUB", "MICROSOFT_FABRIC", "ICEBERG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_type: str

        :param id:
            The value to assign to the id property of this GooglePubSubConnection.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this GooglePubSubConnection.
        :type display_name: str

        :param description:
            The value to assign to the description property of this GooglePubSubConnection.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this GooglePubSubConnection.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this GooglePubSubConnection.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this GooglePubSubConnection.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this GooglePubSubConnection.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this GooglePubSubConnection.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this GooglePubSubConnection.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this GooglePubSubConnection.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this GooglePubSubConnection.
        :type time_updated: datetime

        :param locks:
            The value to assign to the locks property of this GooglePubSubConnection.
        :type locks: list[oci.golden_gate.models.ResourceLock]

        :param vault_id:
            The value to assign to the vault_id property of this GooglePubSubConnection.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this GooglePubSubConnection.
        :type key_id: str

        :param ingress_ips:
            The value to assign to the ingress_ips property of this GooglePubSubConnection.
        :type ingress_ips: list[oci.golden_gate.models.IngressIpDetails]

        :param nsg_ids:
            The value to assign to the nsg_ids property of this GooglePubSubConnection.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this GooglePubSubConnection.
        :type subnet_id: str

        :param routing_method:
            The value to assign to the routing_method property of this GooglePubSubConnection.
            Allowed values for this property are: "SHARED_SERVICE_ENDPOINT", "SHARED_DEPLOYMENT_ENDPOINT", "DEDICATED_ENDPOINT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type routing_method: str

        :param does_use_secret_ids:
            The value to assign to the does_use_secret_ids property of this GooglePubSubConnection.
        :type does_use_secret_ids: bool

        :param subscription_id:
            The value to assign to the subscription_id property of this GooglePubSubConnection.
        :type subscription_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this GooglePubSubConnection.
        :type cluster_placement_group_id: str

        :param security_attributes:
            The value to assign to the security_attributes property of this GooglePubSubConnection.
        :type security_attributes: dict(str, dict(str, object))

        :param technology_type:
            The value to assign to the technology_type property of this GooglePubSubConnection.
            Allowed values for this property are: "GOOGLE_PUBSUB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type technology_type: str

        :param service_account_key_file_secret_id:
            The value to assign to the service_account_key_file_secret_id property of this GooglePubSubConnection.
        :type service_account_key_file_secret_id: str

        """
        self.swagger_types = {
            'connection_type': 'str',
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'locks': 'list[ResourceLock]',
            'vault_id': 'str',
            'key_id': 'str',
            'ingress_ips': 'list[IngressIpDetails]',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'routing_method': 'str',
            'does_use_secret_ids': 'bool',
            'subscription_id': 'str',
            'cluster_placement_group_id': 'str',
            'security_attributes': 'dict(str, dict(str, object))',
            'technology_type': 'str',
            'service_account_key_file_secret_id': 'str'
        }
        self.attribute_map = {
            'connection_type': 'connectionType',
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'locks': 'locks',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'ingress_ips': 'ingressIps',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'routing_method': 'routingMethod',
            'does_use_secret_ids': 'doesUseSecretIds',
            'subscription_id': 'subscriptionId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'security_attributes': 'securityAttributes',
            'technology_type': 'technologyType',
            'service_account_key_file_secret_id': 'serviceAccountKeyFileSecretId'
        }
        self._connection_type = None
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._locks = None
        self._vault_id = None
        self._key_id = None
        self._ingress_ips = None
        self._nsg_ids = None
        self._subnet_id = None
        self._routing_method = None
        self._does_use_secret_ids = None
        self._subscription_id = None
        self._cluster_placement_group_id = None
        self._security_attributes = None
        self._technology_type = None
        self._service_account_key_file_secret_id = None
        self._connection_type = 'GOOGLE_PUBSUB'

    @property
    def technology_type(self):
        """
        **[Required]** Gets the technology_type of this GooglePubSubConnection.
        The Google PubSub technology type.

        Allowed values for this property are: "GOOGLE_PUBSUB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The technology_type of this GooglePubSubConnection.
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """
        Sets the technology_type of this GooglePubSubConnection.
        The Google PubSub technology type.


        :param technology_type: The technology_type of this GooglePubSubConnection.
        :type: str
        """
        allowed_values = ["GOOGLE_PUBSUB"]
        if not value_allowed_none_or_none_sentinel(technology_type, allowed_values):
            technology_type = 'UNKNOWN_ENUM_VALUE'
        self._technology_type = technology_type

    @property
    def service_account_key_file_secret_id(self):
        """
        Gets the service_account_key_file_secret_id of this GooglePubSubConnection.
        The `OCID`__ of the Secret where the content of the service account key file is stored,
        which contains the credentials required to use Google PubSub.
        Note: When provided, 'serviceAccountKeyFile' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The service_account_key_file_secret_id of this GooglePubSubConnection.
        :rtype: str
        """
        return self._service_account_key_file_secret_id

    @service_account_key_file_secret_id.setter
    def service_account_key_file_secret_id(self, service_account_key_file_secret_id):
        """
        Sets the service_account_key_file_secret_id of this GooglePubSubConnection.
        The `OCID`__ of the Secret where the content of the service account key file is stored,
        which contains the credentials required to use Google PubSub.
        Note: When provided, 'serviceAccountKeyFile' field must not be provided.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param service_account_key_file_secret_id: The service_account_key_file_secret_id of this GooglePubSubConnection.
        :type: str
        """
        self._service_account_key_file_secret_id = service_account_key_file_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
