# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InitialDataLoad(object):
    """
    Options required for the pipeline Initial Data Load. If enabled, copies existing data from source to target before replication.
    """

    #: A constant which can be used with the is_initial_load property of a InitialDataLoad.
    #: This constant has a value of "ENABLED"
    IS_INITIAL_LOAD_ENABLED = "ENABLED"

    #: A constant which can be used with the is_initial_load property of a InitialDataLoad.
    #: This constant has a value of "DISABLED"
    IS_INITIAL_LOAD_DISABLED = "DISABLED"

    #: A constant which can be used with the action_on_existing_table property of a InitialDataLoad.
    #: This constant has a value of "TRUNCATE"
    ACTION_ON_EXISTING_TABLE_TRUNCATE = "TRUNCATE"

    #: A constant which can be used with the action_on_existing_table property of a InitialDataLoad.
    #: This constant has a value of "REPLACE"
    ACTION_ON_EXISTING_TABLE_REPLACE = "REPLACE"

    #: A constant which can be used with the action_on_existing_table property of a InitialDataLoad.
    #: This constant has a value of "APPEND"
    ACTION_ON_EXISTING_TABLE_APPEND = "APPEND"

    #: A constant which can be used with the action_on_existing_table property of a InitialDataLoad.
    #: This constant has a value of "SKIP"
    ACTION_ON_EXISTING_TABLE_SKIP = "SKIP"

    def __init__(self, **kwargs):
        """
        Initializes a new InitialDataLoad object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_initial_load:
            The value to assign to the is_initial_load property of this InitialDataLoad.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type is_initial_load: str

        :param action_on_existing_table:
            The value to assign to the action_on_existing_table property of this InitialDataLoad.
            Allowed values for this property are: "TRUNCATE", "REPLACE", "APPEND", "SKIP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_on_existing_table: str

        """
        self.swagger_types = {
            'is_initial_load': 'str',
            'action_on_existing_table': 'str'
        }
        self.attribute_map = {
            'is_initial_load': 'isInitialLoad',
            'action_on_existing_table': 'actionOnExistingTable'
        }
        self._is_initial_load = None
        self._action_on_existing_table = None

    @property
    def is_initial_load(self):
        """
        **[Required]** Gets the is_initial_load of this InitialDataLoad.
        If ENABLED, then existing source data is also synchronized to the target when creating or updating the pipeline.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The is_initial_load of this InitialDataLoad.
        :rtype: str
        """
        return self._is_initial_load

    @is_initial_load.setter
    def is_initial_load(self, is_initial_load):
        """
        Sets the is_initial_load of this InitialDataLoad.
        If ENABLED, then existing source data is also synchronized to the target when creating or updating the pipeline.


        :param is_initial_load: The is_initial_load of this InitialDataLoad.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(is_initial_load, allowed_values):
            is_initial_load = 'UNKNOWN_ENUM_VALUE'
        self._is_initial_load = is_initial_load

    @property
    def action_on_existing_table(self):
        """
        Gets the action_on_existing_table of this InitialDataLoad.
        Action upon existing tables in target when initial Data Load is set i.e., isInitialLoad=true.

        Allowed values for this property are: "TRUNCATE", "REPLACE", "APPEND", "SKIP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_on_existing_table of this InitialDataLoad.
        :rtype: str
        """
        return self._action_on_existing_table

    @action_on_existing_table.setter
    def action_on_existing_table(self, action_on_existing_table):
        """
        Sets the action_on_existing_table of this InitialDataLoad.
        Action upon existing tables in target when initial Data Load is set i.e., isInitialLoad=true.


        :param action_on_existing_table: The action_on_existing_table of this InitialDataLoad.
        :type: str
        """
        allowed_values = ["TRUNCATE", "REPLACE", "APPEND", "SKIP"]
        if not value_allowed_none_or_none_sentinel(action_on_existing_table, allowed_values):
            action_on_existing_table = 'UNKNOWN_ENUM_VALUE'
        self._action_on_existing_table = action_on_existing_table

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
