# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineSchemaTableSummary(object):
    """
    Summary of source or target schema tables of a pipeline's assigned connection.
    1. If there is no explicit mapping defined for the pipeline then only matched source and target schema's table names will be returned
    2. If there are explicit mappings defined for the pipeline then along with the mapped source and target schema's table names, the matched source and target schema's table names also will be returned.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineSchemaTableSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_table_name:
            The value to assign to the source_table_name property of this PipelineSchemaTableSummary.
        :type source_table_name: str

        :param target_table_name:
            The value to assign to the target_table_name property of this PipelineSchemaTableSummary.
        :type target_table_name: str

        """
        self.swagger_types = {
            'source_table_name': 'str',
            'target_table_name': 'str'
        }
        self.attribute_map = {
            'source_table_name': 'sourceTableName',
            'target_table_name': 'targetTableName'
        }
        self._source_table_name = None
        self._target_table_name = None

    @property
    def source_table_name(self):
        """
        **[Required]** Gets the source_table_name of this PipelineSchemaTableSummary.
        The table name from the schema of database connection.


        :return: The source_table_name of this PipelineSchemaTableSummary.
        :rtype: str
        """
        return self._source_table_name

    @source_table_name.setter
    def source_table_name(self, source_table_name):
        """
        Sets the source_table_name of this PipelineSchemaTableSummary.
        The table name from the schema of database connection.


        :param source_table_name: The source_table_name of this PipelineSchemaTableSummary.
        :type: str
        """
        self._source_table_name = source_table_name

    @property
    def target_table_name(self):
        """
        **[Required]** Gets the target_table_name of this PipelineSchemaTableSummary.
        The table name from the schema of database connection.


        :return: The target_table_name of this PipelineSchemaTableSummary.
        :rtype: str
        """
        return self._target_table_name

    @target_table_name.setter
    def target_table_name(self, target_table_name):
        """
        Sets the target_table_name of this PipelineSchemaTableSummary.
        The table name from the schema of database connection.


        :param target_table_name: The target_table_name of this PipelineSchemaTableSummary.
        :type: str
        """
        self._target_table_name = target_table_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
