# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecipeSummary(object):
    """
    The list of recipe details to create pipelines.
    """

    #: A constant which can be used with the recipe_type property of a RecipeSummary.
    #: This constant has a value of "ZERO_ETL"
    RECIPE_TYPE_ZERO_ETL = "ZERO_ETL"

    def __init__(self, **kwargs):
        """
        Initializes a new RecipeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param recipe_type:
            The value to assign to the recipe_type property of this RecipeSummary.
            Allowed values for this property are: "ZERO_ETL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type recipe_type: str

        :param name:
            The value to assign to the name property of this RecipeSummary.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this RecipeSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this RecipeSummary.
        :type description: str

        :param supported_source_technology_types:
            The value to assign to the supported_source_technology_types property of this RecipeSummary.
        :type supported_source_technology_types: list[oci.golden_gate.models.TechnologyType]

        :param supported_target_technology_types:
            The value to assign to the supported_target_technology_types property of this RecipeSummary.
        :type supported_target_technology_types: list[oci.golden_gate.models.TechnologyType]

        """
        self.swagger_types = {
            'recipe_type': 'str',
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'supported_source_technology_types': 'list[TechnologyType]',
            'supported_target_technology_types': 'list[TechnologyType]'
        }
        self.attribute_map = {
            'recipe_type': 'recipeType',
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'supported_source_technology_types': 'supportedSourceTechnologyTypes',
            'supported_target_technology_types': 'supportedTargetTechnologyTypes'
        }
        self._recipe_type = None
        self._name = None
        self._display_name = None
        self._description = None
        self._supported_source_technology_types = None
        self._supported_target_technology_types = None

    @property
    def recipe_type(self):
        """
        **[Required]** Gets the recipe_type of this RecipeSummary.
        The type of the recipe

        Allowed values for this property are: "ZERO_ETL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The recipe_type of this RecipeSummary.
        :rtype: str
        """
        return self._recipe_type

    @recipe_type.setter
    def recipe_type(self, recipe_type):
        """
        Sets the recipe_type of this RecipeSummary.
        The type of the recipe


        :param recipe_type: The recipe_type of this RecipeSummary.
        :type: str
        """
        allowed_values = ["ZERO_ETL"]
        if not value_allowed_none_or_none_sentinel(recipe_type, allowed_values):
            recipe_type = 'UNKNOWN_ENUM_VALUE'
        self._recipe_type = recipe_type

    @property
    def name(self):
        """
        **[Required]** Gets the name of this RecipeSummary.
        An object's Display Name.


        :return: The name of this RecipeSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RecipeSummary.
        An object's Display Name.


        :param name: The name of this RecipeSummary.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this RecipeSummary.
        An object's Display Name.


        :return: The display_name of this RecipeSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this RecipeSummary.
        An object's Display Name.


        :param display_name: The display_name of this RecipeSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this RecipeSummary.
        Metadata about this specific object.


        :return: The description of this RecipeSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this RecipeSummary.
        Metadata about this specific object.


        :param description: The description of this RecipeSummary.
        :type: str
        """
        self._description = description

    @property
    def supported_source_technology_types(self):
        """
        **[Required]** Gets the supported_source_technology_types of this RecipeSummary.
        Array of supported technology types for this recipe.


        :return: The supported_source_technology_types of this RecipeSummary.
        :rtype: list[oci.golden_gate.models.TechnologyType]
        """
        return self._supported_source_technology_types

    @supported_source_technology_types.setter
    def supported_source_technology_types(self, supported_source_technology_types):
        """
        Sets the supported_source_technology_types of this RecipeSummary.
        Array of supported technology types for this recipe.


        :param supported_source_technology_types: The supported_source_technology_types of this RecipeSummary.
        :type: list[oci.golden_gate.models.TechnologyType]
        """
        self._supported_source_technology_types = supported_source_technology_types

    @property
    def supported_target_technology_types(self):
        """
        **[Required]** Gets the supported_target_technology_types of this RecipeSummary.
        Array of supported technology types for this recipe.


        :return: The supported_target_technology_types of this RecipeSummary.
        :rtype: list[oci.golden_gate.models.TechnologyType]
        """
        return self._supported_target_technology_types

    @supported_target_technology_types.setter
    def supported_target_technology_types(self, supported_target_technology_types):
        """
        Sets the supported_target_technology_types of this RecipeSummary.
        Array of supported technology types for this recipe.


        :param supported_target_technology_types: The supported_target_technology_types of this RecipeSummary.
        :type: list[oci.golden_gate.models.TechnologyType]
        """
        self._supported_target_technology_types = supported_target_technology_types

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
