# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciConsoleSignOnPolicyConsentModifiedResource(object):
    """
    The modified Policy, Rule, ConditionGroup or Condition during consent signing.

    **SCIM++ Properties:**
    - idcsSearchable: false
    - multiValued: false
    - mutability: immutable
    - required: true
    - returned: default
    - type: complex
    - uniqueness: none
    """

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentModifiedResource.
    #: This constant has a value of "Policy"
    TYPE_POLICY = "Policy"

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentModifiedResource.
    #: This constant has a value of "Rule"
    TYPE_RULE = "Rule"

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentModifiedResource.
    #: This constant has a value of "ConditionGroup"
    TYPE_CONDITION_GROUP = "ConditionGroup"

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentModifiedResource.
    #: This constant has a value of "Condition"
    TYPE_CONDITION = "Condition"

    def __init__(self, **kwargs):
        """
        Initializes a new OciConsoleSignOnPolicyConsentModifiedResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this OciConsoleSignOnPolicyConsentModifiedResource.
        :type value: str

        :param ocid:
            The value to assign to the ocid property of this OciConsoleSignOnPolicyConsentModifiedResource.
        :type ocid: str

        :param type:
            The value to assign to the type property of this OciConsoleSignOnPolicyConsentModifiedResource.
            Allowed values for this property are: "Policy", "Rule", "ConditionGroup", "Condition", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'value': 'str',
            'ocid': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'value': 'value',
            'ocid': 'ocid',
            'type': 'type'
        }
        self._value = None
        self._ocid = None
        self._type = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this OciConsoleSignOnPolicyConsentModifiedResource.
        Modified Policy, Rule, ConditionGroup or Condition Id.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :return: The value of this OciConsoleSignOnPolicyConsentModifiedResource.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this OciConsoleSignOnPolicyConsentModifiedResource.
        Modified Policy, Rule, ConditionGroup or Condition Id.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param value: The value of this OciConsoleSignOnPolicyConsentModifiedResource.
        :type: str
        """
        self._value = value

    @property
    def ocid(self):
        """
        **[Required]** Gets the ocid of this OciConsoleSignOnPolicyConsentModifiedResource.
        The modified Policy, Rule, ConditionGroup, or Condition OCID.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :return: The ocid of this OciConsoleSignOnPolicyConsentModifiedResource.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this OciConsoleSignOnPolicyConsentModifiedResource.
        The modified Policy, Rule, ConditionGroup, or Condition OCID.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param ocid: The ocid of this OciConsoleSignOnPolicyConsentModifiedResource.
        :type: str
        """
        self._ocid = ocid

    @property
    def type(self):
        """
        **[Required]** Gets the type of this OciConsoleSignOnPolicyConsentModifiedResource.
        The Modified Resource type - Policy, Rule, ConditionGroup, or Condition. A label that indicates the resource type.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - idcsDefaultValue: Policy
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Policy", "Rule", "ConditionGroup", "Condition", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this OciConsoleSignOnPolicyConsentModifiedResource.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this OciConsoleSignOnPolicyConsentModifiedResource.
        The Modified Resource type - Policy, Rule, ConditionGroup, or Condition. A label that indicates the resource type.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - idcsDefaultValue: Policy
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this OciConsoleSignOnPolicyConsentModifiedResource.
        :type: str
        """
        allowed_values = ["Policy", "Rule", "ConditionGroup", "Condition"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
