# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConvertInstanceDetails(object):
    """
    Details for converting integration instance to Disaster Recovery Enabled instance type
    """

    #: A constant which can be used with the conversion_type property of a ConvertInstanceDetails.
    #: This constant has a value of "DISASTER_RECOVERY"
    CONVERSION_TYPE_DISASTER_RECOVERY = "DISASTER_RECOVERY"

    def __init__(self, **kwargs):
        """
        Initializes a new ConvertInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param conversion_type:
            The value to assign to the conversion_type property of this ConvertInstanceDetails.
            Allowed values for this property are: "DISASTER_RECOVERY"
        :type conversion_type: str

        """
        self.swagger_types = {
            'conversion_type': 'str'
        }
        self.attribute_map = {
            'conversion_type': 'conversionType'
        }
        self._conversion_type = None

    @property
    def conversion_type(self):
        """
        **[Required]** Gets the conversion_type of this ConvertInstanceDetails.
        Convert given instance to specified DR instance

        Allowed values for this property are: "DISASTER_RECOVERY"


        :return: The conversion_type of this ConvertInstanceDetails.
        :rtype: str
        """
        return self._conversion_type

    @conversion_type.setter
    def conversion_type(self, conversion_type):
        """
        Sets the conversion_type of this ConvertInstanceDetails.
        Convert given instance to specified DR instance


        :param conversion_type: The conversion_type of this ConvertInstanceDetails.
        :type: str
        """
        allowed_values = ["DISASTER_RECOVERY"]
        if not value_allowed_none_or_none_sentinel(conversion_type, allowed_values):
            raise ValueError(
                f"Invalid value for `conversion_type`, must be None or one of {allowed_values}"
            )
        self._conversion_type = conversion_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
