# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigureIotDomainGroupDataAccessDetails(object):
    """
    The configuration details for an IoT Domain Group Data Access through allowlisted vcn ids.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigureIotDomainGroupDataAccessDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_allow_listed_vcn_ids:
            The value to assign to the db_allow_listed_vcn_ids property of this ConfigureIotDomainGroupDataAccessDetails.
        :type db_allow_listed_vcn_ids: list[str]

        """
        self.swagger_types = {
            'db_allow_listed_vcn_ids': 'list[str]'
        }
        self.attribute_map = {
            'db_allow_listed_vcn_ids': 'dbAllowListedVcnIds'
        }
        self._db_allow_listed_vcn_ids = None

    @property
    def db_allow_listed_vcn_ids(self):
        """
        **[Required]** Gets the db_allow_listed_vcn_ids of this ConfigureIotDomainGroupDataAccessDetails.
        This is an array of VCN OCID (virtual cloud network Oracle Cloud ID) that is allowed to connect the data host.


        :return: The db_allow_listed_vcn_ids of this ConfigureIotDomainGroupDataAccessDetails.
        :rtype: list[str]
        """
        return self._db_allow_listed_vcn_ids

    @db_allow_listed_vcn_ids.setter
    def db_allow_listed_vcn_ids(self, db_allow_listed_vcn_ids):
        """
        Sets the db_allow_listed_vcn_ids of this ConfigureIotDomainGroupDataAccessDetails.
        This is an array of VCN OCID (virtual cloud network Oracle Cloud ID) that is allowed to connect the data host.


        :param db_allow_listed_vcn_ids: The db_allow_listed_vcn_ids of this ConfigureIotDomainGroupDataAccessDetails.
        :type: list[str]
        """
        self._db_allow_listed_vcn_ids = db_allow_listed_vcn_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
