# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinAdapterInboundEnvelope(object):
    """
    Payload containing device-specific metadata and optional value mappings used to interpret
    or transform that metadata. This structure includes the device endpoint, the actual payload,
    and an optional envelope mapping that applies `JQ`__ expressions
    to extract or reshape the data as needed.

    __ https://stedolan.github.io/jq/
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinAdapterInboundEnvelope object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reference_endpoint:
            The value to assign to the reference_endpoint property of this DigitalTwinAdapterInboundEnvelope.
        :type reference_endpoint: str

        :param reference_payload:
            The value to assign to the reference_payload property of this DigitalTwinAdapterInboundEnvelope.
        :type reference_payload: oci.iot.models.DigitalTwinAdapterPayload

        :param envelope_mapping:
            The value to assign to the envelope_mapping property of this DigitalTwinAdapterInboundEnvelope.
        :type envelope_mapping: oci.iot.models.DigitalTwinAdapterEnvelopeMapping

        """
        self.swagger_types = {
            'reference_endpoint': 'str',
            'reference_payload': 'DigitalTwinAdapterPayload',
            'envelope_mapping': 'DigitalTwinAdapterEnvelopeMapping'
        }
        self.attribute_map = {
            'reference_endpoint': 'referenceEndpoint',
            'reference_payload': 'referencePayload',
            'envelope_mapping': 'envelopeMapping'
        }
        self._reference_endpoint = None
        self._reference_payload = None
        self._envelope_mapping = None

    @property
    def reference_endpoint(self):
        """
        **[Required]** Gets the reference_endpoint of this DigitalTwinAdapterInboundEnvelope.
        The device endpoint.


        :return: The reference_endpoint of this DigitalTwinAdapterInboundEnvelope.
        :rtype: str
        """
        return self._reference_endpoint

    @reference_endpoint.setter
    def reference_endpoint(self, reference_endpoint):
        """
        Sets the reference_endpoint of this DigitalTwinAdapterInboundEnvelope.
        The device endpoint.


        :param reference_endpoint: The reference_endpoint of this DigitalTwinAdapterInboundEnvelope.
        :type: str
        """
        self._reference_endpoint = reference_endpoint

    @property
    def reference_payload(self):
        """
        Gets the reference_payload of this DigitalTwinAdapterInboundEnvelope.

        :return: The reference_payload of this DigitalTwinAdapterInboundEnvelope.
        :rtype: oci.iot.models.DigitalTwinAdapterPayload
        """
        return self._reference_payload

    @reference_payload.setter
    def reference_payload(self, reference_payload):
        """
        Sets the reference_payload of this DigitalTwinAdapterInboundEnvelope.

        :param reference_payload: The reference_payload of this DigitalTwinAdapterInboundEnvelope.
        :type: oci.iot.models.DigitalTwinAdapterPayload
        """
        self._reference_payload = reference_payload

    @property
    def envelope_mapping(self):
        """
        Gets the envelope_mapping of this DigitalTwinAdapterInboundEnvelope.

        :return: The envelope_mapping of this DigitalTwinAdapterInboundEnvelope.
        :rtype: oci.iot.models.DigitalTwinAdapterEnvelopeMapping
        """
        return self._envelope_mapping

    @envelope_mapping.setter
    def envelope_mapping(self, envelope_mapping):
        """
        Sets the envelope_mapping of this DigitalTwinAdapterInboundEnvelope.

        :param envelope_mapping: The envelope_mapping of this DigitalTwinAdapterInboundEnvelope.
        :type: oci.iot.models.DigitalTwinAdapterEnvelopeMapping
        """
        self._envelope_mapping = envelope_mapping

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
