# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531

from .digital_twin_adapter_payload import DigitalTwinAdapterPayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinAdapterJsonPayload(DigitalTwinAdapterPayload):
    """
    A payload structure containing JSON-formatted data from the digital twin device.
    This schema should be used when the parent payload 'dataFormat' is set to `JSON`.
    The `data` property contains the reference JSON content being passed from the device.

    Example: `{\"temperature\": 0,\"location\": {\"type\": \"point\"},\"serialNumber\": \"<serialNumber>\"}`
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinAdapterJsonPayload object with values from keyword arguments. The default value of the :py:attr:`~oci.iot.models.DigitalTwinAdapterJsonPayload.data_format` attribute
        of this class is ``JSON`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_format:
            The value to assign to the data_format property of this DigitalTwinAdapterJsonPayload.
            Allowed values for this property are: "JSON"
        :type data_format: str

        :param data:
            The value to assign to the data property of this DigitalTwinAdapterJsonPayload.
        :type data: dict(str, object)

        """
        self.swagger_types = {
            'data_format': 'str',
            'data': 'dict(str, object)'
        }
        self.attribute_map = {
            'data_format': 'dataFormat',
            'data': 'data'
        }
        self._data_format = None
        self._data = None
        self._data_format = 'JSON'

    @property
    def data(self):
        """
        **[Required]** Gets the data of this DigitalTwinAdapterJsonPayload.
        JSON raw data.


        :return: The data of this DigitalTwinAdapterJsonPayload.
        :rtype: dict(str, object)
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this DigitalTwinAdapterJsonPayload.
        JSON raw data.


        :param data: The data of this DigitalTwinAdapterJsonPayload.
        :type: dict(str, object)
        """
        self._data = data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
