# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IotDomainGroup(object):
    """
    An IoT domain group is an Oracle Cloud Infrastructure resource that provides a managed environment for organizing
    and managing IoT domains, within a compartment.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a IotDomainGroup.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new IotDomainGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IotDomainGroup.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this IotDomainGroup.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this IotDomainGroup.
        :type display_name: str

        :param description:
            The value to assign to the description property of this IotDomainGroup.
        :type description: str

        :param data_host:
            The value to assign to the data_host property of this IotDomainGroup.
        :type data_host: str

        :param db_allow_listed_vcn_ids:
            The value to assign to the db_allow_listed_vcn_ids property of this IotDomainGroup.
        :type db_allow_listed_vcn_ids: list[str]

        :param db_connection_string:
            The value to assign to the db_connection_string property of this IotDomainGroup.
        :type db_connection_string: str

        :param db_token_scope:
            The value to assign to the db_token_scope property of this IotDomainGroup.
        :type db_token_scope: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this IotDomainGroup.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this IotDomainGroup.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this IotDomainGroup.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this IotDomainGroup.
        :type system_tags: dict(str, dict(str, object))

        :param time_created:
            The value to assign to the time_created property of this IotDomainGroup.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this IotDomainGroup.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'data_host': 'str',
            'db_allow_listed_vcn_ids': 'list[str]',
            'db_connection_string': 'str',
            'db_token_scope': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'data_host': 'dataHost',
            'db_allow_listed_vcn_ids': 'dbAllowListedVcnIds',
            'db_connection_string': 'dbConnectionString',
            'db_token_scope': 'dbTokenScope',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._data_host = None
        self._db_allow_listed_vcn_ids = None
        self._db_connection_string = None
        self._db_token_scope = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this IotDomainGroup.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this IotDomainGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IotDomainGroup.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this IotDomainGroup.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this IotDomainGroup.
        The `OCID`__ of the compartment corresponding to the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this IotDomainGroup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this IotDomainGroup.
        The `OCID`__ of the compartment corresponding to the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this IotDomainGroup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this IotDomainGroup.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this IotDomainGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this IotDomainGroup.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this IotDomainGroup.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this IotDomainGroup.
        A short description of the resource.


        :return: The description of this IotDomainGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this IotDomainGroup.
        A short description of the resource.


        :param description: The description of this IotDomainGroup.
        :type: str
        """
        self._description = description

    @property
    def data_host(self):
        """
        Gets the data_host of this IotDomainGroup.
        The host name of the database corresponding to the IoT Domain group.


        :return: The data_host of this IotDomainGroup.
        :rtype: str
        """
        return self._data_host

    @data_host.setter
    def data_host(self, data_host):
        """
        Sets the data_host of this IotDomainGroup.
        The host name of the database corresponding to the IoT Domain group.


        :param data_host: The data_host of this IotDomainGroup.
        :type: str
        """
        self._data_host = data_host

    @property
    def db_allow_listed_vcn_ids(self):
        """
        Gets the db_allow_listed_vcn_ids of this IotDomainGroup.
        This is an array of VCN OCID (virtual cloud network Oracle Cloud ID) that is allowed to connect the data host.


        :return: The db_allow_listed_vcn_ids of this IotDomainGroup.
        :rtype: list[str]
        """
        return self._db_allow_listed_vcn_ids

    @db_allow_listed_vcn_ids.setter
    def db_allow_listed_vcn_ids(self, db_allow_listed_vcn_ids):
        """
        Sets the db_allow_listed_vcn_ids of this IotDomainGroup.
        This is an array of VCN OCID (virtual cloud network Oracle Cloud ID) that is allowed to connect the data host.


        :param db_allow_listed_vcn_ids: The db_allow_listed_vcn_ids of this IotDomainGroup.
        :type: list[str]
        """
        self._db_allow_listed_vcn_ids = db_allow_listed_vcn_ids

    @property
    def db_connection_string(self):
        """
        Gets the db_connection_string of this IotDomainGroup.
        The connection string used to connect to the data host associated with the IoT domain group.


        :return: The db_connection_string of this IotDomainGroup.
        :rtype: str
        """
        return self._db_connection_string

    @db_connection_string.setter
    def db_connection_string(self, db_connection_string):
        """
        Sets the db_connection_string of this IotDomainGroup.
        The connection string used to connect to the data host associated with the IoT domain group.


        :param db_connection_string: The db_connection_string of this IotDomainGroup.
        :type: str
        """
        self._db_connection_string = db_connection_string

    @property
    def db_token_scope(self):
        """
        Gets the db_token_scope of this IotDomainGroup.
        The token scope used to connect to the data host associated with the IoT domain group.


        :return: The db_token_scope of this IotDomainGroup.
        :rtype: str
        """
        return self._db_token_scope

    @db_token_scope.setter
    def db_token_scope(self, db_token_scope):
        """
        Sets the db_token_scope of this IotDomainGroup.
        The token scope used to connect to the data host associated with the IoT domain group.


        :param db_token_scope: The db_token_scope of this IotDomainGroup.
        :type: str
        """
        self._db_token_scope = db_token_scope

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this IotDomainGroup.
        The current state of an IoT Domain Group.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this IotDomainGroup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this IotDomainGroup.
        The current state of an IoT Domain Group.


        :param lifecycle_state: The lifecycle_state of this IotDomainGroup.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this IotDomainGroup.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this IotDomainGroup.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this IotDomainGroup.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this IotDomainGroup.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this IotDomainGroup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this IotDomainGroup.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this IotDomainGroup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this IotDomainGroup.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this IotDomainGroup.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this IotDomainGroup.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this IotDomainGroup.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this IotDomainGroup.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this IotDomainGroup.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this IotDomainGroup.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this IotDomainGroup.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this IotDomainGroup.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this IotDomainGroup.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this IotDomainGroup.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this IotDomainGroup.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this IotDomainGroup.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
