# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610

from .work_item_details import WorkItemDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaMigrationDeployedApplicationWorkItemDetails(WorkItemDetails):
    """
    The java migration work item details for deployed application analysis related information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JavaMigrationDeployedApplicationWorkItemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.jms.models.JavaMigrationDeployedApplicationWorkItemDetails.kind` attribute
        of this class is ``JAVA_MIGRATION_DEPLOYED_APPLICATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this JavaMigrationDeployedApplicationWorkItemDetails.
            Allowed values for this property are: "BASIC", "APPLICATION", "LCM", "DEPLOYED_APPLICATION"
        :type kind: str

        :param work_item_type:
            The value to assign to the work_item_type property of this JavaMigrationDeployedApplicationWorkItemDetails.
            Allowed values for this property are: "LCM", "JFR_CAPTURE", "JFR_UPLOAD", "CRYPTO_ANALYSIS", "CRYPTO_ANALYSIS_MERGE", "ADVANCED_USAGE_TRACKING", "ADV_USAGE_SERVER_METADATA", "ADV_USAGE_SERVER_LIBRARIES", "ADV_USAGE_JAVA_LIBRARIES", "ADV_USAGE_JAVA_LIBRARIES_DYNAMIC", "PERFORMANCE_TUNING", "JMIGRATE_ANALYSIS", "JMIGRATE_CREATE_REPORT", "DRS"
        :type work_item_type: str

        :param deployed_application_key:
            The value to assign to the deployed_application_key property of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type deployed_application_key: str

        :param deployed_application_installation_key:
            The value to assign to the deployed_application_installation_key property of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type deployed_application_installation_key: str

        :param deployed_application_name:
            The value to assign to the deployed_application_name property of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type deployed_application_name: str

        :param deployed_application_installation_path:
            The value to assign to the deployed_application_installation_path property of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type deployed_application_installation_path: str

        :param target_jdk_version:
            The value to assign to the target_jdk_version property of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type target_jdk_version: str

        """
        self.swagger_types = {
            'kind': 'str',
            'work_item_type': 'str',
            'deployed_application_key': 'str',
            'deployed_application_installation_key': 'str',
            'deployed_application_name': 'str',
            'deployed_application_installation_path': 'str',
            'target_jdk_version': 'str'
        }
        self.attribute_map = {
            'kind': 'kind',
            'work_item_type': 'workItemType',
            'deployed_application_key': 'deployedApplicationKey',
            'deployed_application_installation_key': 'deployedApplicationInstallationKey',
            'deployed_application_name': 'deployedApplicationName',
            'deployed_application_installation_path': 'deployedApplicationInstallationPath',
            'target_jdk_version': 'targetJdkVersion'
        }
        self._kind = None
        self._work_item_type = None
        self._deployed_application_key = None
        self._deployed_application_installation_key = None
        self._deployed_application_name = None
        self._deployed_application_installation_path = None
        self._target_jdk_version = None
        self._kind = 'JAVA_MIGRATION_DEPLOYED_APPLICATION'

    @property
    def deployed_application_key(self):
        """
        **[Required]** Gets the deployed_application_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        The unique key of the deployed application of the java migration analysis.


        :return: The deployed_application_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        :rtype: str
        """
        return self._deployed_application_key

    @deployed_application_key.setter
    def deployed_application_key(self, deployed_application_key):
        """
        Sets the deployed_application_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        The unique key of the deployed application of the java migration analysis.


        :param deployed_application_key: The deployed_application_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type: str
        """
        self._deployed_application_key = deployed_application_key

    @property
    def deployed_application_installation_key(self):
        """
        Gets the deployed_application_installation_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        The unique key of the deployed application installation of the java migration analysis.


        :return: The deployed_application_installation_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        :rtype: str
        """
        return self._deployed_application_installation_key

    @deployed_application_installation_key.setter
    def deployed_application_installation_key(self, deployed_application_installation_key):
        """
        Sets the deployed_application_installation_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        The unique key of the deployed application installation of the java migration analysis.


        :param deployed_application_installation_key: The deployed_application_installation_key of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type: str
        """
        self._deployed_application_installation_key = deployed_application_installation_key

    @property
    def deployed_application_name(self):
        """
        **[Required]** Gets the deployed_application_name of this JavaMigrationDeployedApplicationWorkItemDetails.
        The deployed application name.


        :return: The deployed_application_name of this JavaMigrationDeployedApplicationWorkItemDetails.
        :rtype: str
        """
        return self._deployed_application_name

    @deployed_application_name.setter
    def deployed_application_name(self, deployed_application_name):
        """
        Sets the deployed_application_name of this JavaMigrationDeployedApplicationWorkItemDetails.
        The deployed application name.


        :param deployed_application_name: The deployed_application_name of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type: str
        """
        self._deployed_application_name = deployed_application_name

    @property
    def deployed_application_installation_path(self):
        """
        Gets the deployed_application_installation_path of this JavaMigrationDeployedApplicationWorkItemDetails.
        The full path on which deployed application installation was detected.


        :return: The deployed_application_installation_path of this JavaMigrationDeployedApplicationWorkItemDetails.
        :rtype: str
        """
        return self._deployed_application_installation_path

    @deployed_application_installation_path.setter
    def deployed_application_installation_path(self, deployed_application_installation_path):
        """
        Sets the deployed_application_installation_path of this JavaMigrationDeployedApplicationWorkItemDetails.
        The full path on which deployed application installation was detected.


        :param deployed_application_installation_path: The deployed_application_installation_path of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type: str
        """
        self._deployed_application_installation_path = deployed_application_installation_path

    @property
    def target_jdk_version(self):
        """
        Gets the target_jdk_version of this JavaMigrationDeployedApplicationWorkItemDetails.
        The JDK version against which the migration analysis was performed to identify effort required to move from source JDK.


        :return: The target_jdk_version of this JavaMigrationDeployedApplicationWorkItemDetails.
        :rtype: str
        """
        return self._target_jdk_version

    @target_jdk_version.setter
    def target_jdk_version(self, target_jdk_version):
        """
        Sets the target_jdk_version of this JavaMigrationDeployedApplicationWorkItemDetails.
        The JDK version against which the migration analysis was performed to identify effort required to move from source JDK.


        :param target_jdk_version: The target_jdk_version of this JavaMigrationDeployedApplicationWorkItemDetails.
        :type: str
        """
        self._target_jdk_version = target_jdk_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
