# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LibraryInventory(object):
    """
    Inventory of libraries in a fleet during a specified time period.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LibraryInventory object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param statically_detected_library_count:
            The value to assign to the statically_detected_library_count property of this LibraryInventory.
        :type statically_detected_library_count: int

        :param dynamically_detected_library_count:
            The value to assign to the dynamically_detected_library_count property of this LibraryInventory.
        :type dynamically_detected_library_count: int

        :param uncorrelated_package_count:
            The value to assign to the uncorrelated_package_count property of this LibraryInventory.
        :type uncorrelated_package_count: int

        :param high_severity_library_count:
            The value to assign to the high_severity_library_count property of this LibraryInventory.
        :type high_severity_library_count: int

        :param medium_severity_library_count:
            The value to assign to the medium_severity_library_count property of this LibraryInventory.
        :type medium_severity_library_count: int

        :param low_severity_library_count:
            The value to assign to the low_severity_library_count property of this LibraryInventory.
        :type low_severity_library_count: int

        """
        self.swagger_types = {
            'statically_detected_library_count': 'int',
            'dynamically_detected_library_count': 'int',
            'uncorrelated_package_count': 'int',
            'high_severity_library_count': 'int',
            'medium_severity_library_count': 'int',
            'low_severity_library_count': 'int'
        }
        self.attribute_map = {
            'statically_detected_library_count': 'staticallyDetectedLibraryCount',
            'dynamically_detected_library_count': 'dynamicallyDetectedLibraryCount',
            'uncorrelated_package_count': 'uncorrelatedPackageCount',
            'high_severity_library_count': 'highSeverityLibraryCount',
            'medium_severity_library_count': 'mediumSeverityLibraryCount',
            'low_severity_library_count': 'lowSeverityLibraryCount'
        }
        self._statically_detected_library_count = None
        self._dynamically_detected_library_count = None
        self._uncorrelated_package_count = None
        self._high_severity_library_count = None
        self._medium_severity_library_count = None
        self._low_severity_library_count = None

    @property
    def statically_detected_library_count(self):
        """
        **[Required]** Gets the statically_detected_library_count of this LibraryInventory.
        The count of libraries which are detected statically.


        :return: The statically_detected_library_count of this LibraryInventory.
        :rtype: int
        """
        return self._statically_detected_library_count

    @statically_detected_library_count.setter
    def statically_detected_library_count(self, statically_detected_library_count):
        """
        Sets the statically_detected_library_count of this LibraryInventory.
        The count of libraries which are detected statically.


        :param statically_detected_library_count: The statically_detected_library_count of this LibraryInventory.
        :type: int
        """
        self._statically_detected_library_count = statically_detected_library_count

    @property
    def dynamically_detected_library_count(self):
        """
        **[Required]** Gets the dynamically_detected_library_count of this LibraryInventory.
        The count of libraries which are detected dynamically.


        :return: The dynamically_detected_library_count of this LibraryInventory.
        :rtype: int
        """
        return self._dynamically_detected_library_count

    @dynamically_detected_library_count.setter
    def dynamically_detected_library_count(self, dynamically_detected_library_count):
        """
        Sets the dynamically_detected_library_count of this LibraryInventory.
        The count of libraries which are detected dynamically.


        :param dynamically_detected_library_count: The dynamically_detected_library_count of this LibraryInventory.
        :type: int
        """
        self._dynamically_detected_library_count = dynamically_detected_library_count

    @property
    def uncorrelated_package_count(self):
        """
        **[Required]** Gets the uncorrelated_package_count of this LibraryInventory.
        The count of packages which are detected but not correlated to any libraries.


        :return: The uncorrelated_package_count of this LibraryInventory.
        :rtype: int
        """
        return self._uncorrelated_package_count

    @uncorrelated_package_count.setter
    def uncorrelated_package_count(self, uncorrelated_package_count):
        """
        Sets the uncorrelated_package_count of this LibraryInventory.
        The count of packages which are detected but not correlated to any libraries.


        :param uncorrelated_package_count: The uncorrelated_package_count of this LibraryInventory.
        :type: int
        """
        self._uncorrelated_package_count = uncorrelated_package_count

    @property
    def high_severity_library_count(self):
        """
        **[Required]** Gets the high_severity_library_count of this LibraryInventory.
        The count of libraries with high severity vulnerabilities.


        :return: The high_severity_library_count of this LibraryInventory.
        :rtype: int
        """
        return self._high_severity_library_count

    @high_severity_library_count.setter
    def high_severity_library_count(self, high_severity_library_count):
        """
        Sets the high_severity_library_count of this LibraryInventory.
        The count of libraries with high severity vulnerabilities.


        :param high_severity_library_count: The high_severity_library_count of this LibraryInventory.
        :type: int
        """
        self._high_severity_library_count = high_severity_library_count

    @property
    def medium_severity_library_count(self):
        """
        **[Required]** Gets the medium_severity_library_count of this LibraryInventory.
        The count of libraries with medium severity vulnerabilities.


        :return: The medium_severity_library_count of this LibraryInventory.
        :rtype: int
        """
        return self._medium_severity_library_count

    @medium_severity_library_count.setter
    def medium_severity_library_count(self, medium_severity_library_count):
        """
        Sets the medium_severity_library_count of this LibraryInventory.
        The count of libraries with medium severity vulnerabilities.


        :param medium_severity_library_count: The medium_severity_library_count of this LibraryInventory.
        :type: int
        """
        self._medium_severity_library_count = medium_severity_library_count

    @property
    def low_severity_library_count(self):
        """
        **[Required]** Gets the low_severity_library_count of this LibraryInventory.
        The count of libraries with low severity vulnerabilities.


        :return: The low_severity_library_count of this LibraryInventory.
        :rtype: int
        """
        return self._low_severity_library_count

    @low_severity_library_count.setter
    def low_severity_library_count(self, low_severity_library_count):
        """
        Sets the low_severity_library_count of this LibraryInventory.
        The count of libraries with low severity vulnerabilities.


        :param low_severity_library_count: The low_severity_library_count of this LibraryInventory.
        :type: int
        """
        self._low_severity_library_count = low_severity_library_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
