# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LibraryVulnerability(object):
    """
    A library vulnerability.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LibraryVulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vulnerability_key:
            The value to assign to the vulnerability_key property of this LibraryVulnerability.
        :type vulnerability_key: str

        :param cvss_score:
            The value to assign to the cvss_score property of this LibraryVulnerability.
        :type cvss_score: float

        """
        self.swagger_types = {
            'vulnerability_key': 'str',
            'cvss_score': 'float'
        }
        self.attribute_map = {
            'vulnerability_key': 'vulnerabilityKey',
            'cvss_score': 'cvssScore'
        }
        self._vulnerability_key = None
        self._cvss_score = None

    @property
    def vulnerability_key(self):
        """
        **[Required]** Gets the vulnerability_key of this LibraryVulnerability.
        The Vulnerability Key, could be CVE or GitHub Security Advisory or others e.g. GHSA-1234-abcd-5678 or CVE-2019-1234


        :return: The vulnerability_key of this LibraryVulnerability.
        :rtype: str
        """
        return self._vulnerability_key

    @vulnerability_key.setter
    def vulnerability_key(self, vulnerability_key):
        """
        Sets the vulnerability_key of this LibraryVulnerability.
        The Vulnerability Key, could be CVE or GitHub Security Advisory or others e.g. GHSA-1234-abcd-5678 or CVE-2019-1234


        :param vulnerability_key: The vulnerability_key of this LibraryVulnerability.
        :type: str
        """
        self._vulnerability_key = vulnerability_key

    @property
    def cvss_score(self):
        """
        **[Required]** Gets the cvss_score of this LibraryVulnerability.
        The Common Vulnerability Scoring System (CVSS) score. If `cvssScore` is not available, it will be set to -1.


        :return: The cvss_score of this LibraryVulnerability.
        :rtype: float
        """
        return self._cvss_score

    @cvss_score.setter
    def cvss_score(self, cvss_score):
        """
        Sets the cvss_score of this LibraryVulnerability.
        The Common Vulnerability Scoring System (CVSS) score. If `cvssScore` is not available, it will be set to -1.


        :param cvss_score: The cvss_score of this LibraryVulnerability.
        :type: float
        """
        self._cvss_score = cvss_score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
