# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610

from .task_details import TaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceTuningTaskDetails(TaskDetails):
    """
    The task details with performance tuning related information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceTuningTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.jms.models.PerformanceTuningTaskDetails.task_type` attribute
        of this class is ``PERFORMANCE_TUNING`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param task_type:
            The value to assign to the task_type property of this PerformanceTuningTaskDetails.
            Allowed values for this property are: "CRYPTO", "JFR", "SCAN_LIBRARY", "SCAN_JAVA_SERVER", "JAVA_MIGRATION", "DEPLOYED_APPLICATION_MIGRATION", "PERFORMANCE_TUNING", "ADD_INSTALLATION_SITE", "REMOVE_INSTALLATION_SITE"
        :type task_type: str

        :param performance_tuning_task_request:
            The value to assign to the performance_tuning_task_request property of this PerformanceTuningTaskDetails.
        :type performance_tuning_task_request: oci.jms.models.RequestPerformanceTuningAnalysesDetails

        """
        self.swagger_types = {
            'task_type': 'str',
            'performance_tuning_task_request': 'RequestPerformanceTuningAnalysesDetails'
        }
        self.attribute_map = {
            'task_type': 'taskType',
            'performance_tuning_task_request': 'performanceTuningTaskRequest'
        }
        self._task_type = None
        self._performance_tuning_task_request = None
        self._task_type = 'PERFORMANCE_TUNING'

    @property
    def performance_tuning_task_request(self):
        """
        Gets the performance_tuning_task_request of this PerformanceTuningTaskDetails.

        :return: The performance_tuning_task_request of this PerformanceTuningTaskDetails.
        :rtype: oci.jms.models.RequestPerformanceTuningAnalysesDetails
        """
        return self._performance_tuning_task_request

    @performance_tuning_task_request.setter
    def performance_tuning_task_request(self, performance_tuning_task_request):
        """
        Sets the performance_tuning_task_request of this PerformanceTuningTaskDetails.

        :param performance_tuning_task_request: The performance_tuning_task_request of this PerformanceTuningTaskDetails.
        :type: oci.jms.models.RequestPerformanceTuningAnalysesDetails
        """
        self._performance_tuning_task_request = performance_tuning_task_request

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
