# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TaskScheduleSummary(object):
    """
    A summary of the task schedule properties.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TaskScheduleSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this TaskScheduleSummary.
        :type id: str

        :param fleet_id:
            The value to assign to the fleet_id property of this TaskScheduleSummary.
        :type fleet_id: str

        :param name:
            The value to assign to the name property of this TaskScheduleSummary.
        :type name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TaskScheduleSummary.
        :type lifecycle_state: str

        :param created_by:
            The value to assign to the created_by property of this TaskScheduleSummary.
        :type created_by: str

        :param execution_recurrences:
            The value to assign to the execution_recurrences property of this TaskScheduleSummary.
        :type execution_recurrences: str

        :param task_details:
            The value to assign to the task_details property of this TaskScheduleSummary.
        :type task_details: oci.jms.models.TaskDetails

        :param time_created:
            The value to assign to the time_created property of this TaskScheduleSummary.
        :type time_created: datetime

        :param time_last_run:
            The value to assign to the time_last_run property of this TaskScheduleSummary.
        :type time_last_run: datetime

        :param time_next_run:
            The value to assign to the time_next_run property of this TaskScheduleSummary.
        :type time_next_run: datetime

        :param time_last_updated:
            The value to assign to the time_last_updated property of this TaskScheduleSummary.
        :type time_last_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'fleet_id': 'str',
            'name': 'str',
            'lifecycle_state': 'str',
            'created_by': 'str',
            'execution_recurrences': 'str',
            'task_details': 'TaskDetails',
            'time_created': 'datetime',
            'time_last_run': 'datetime',
            'time_next_run': 'datetime',
            'time_last_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'fleet_id': 'fleetId',
            'name': 'name',
            'lifecycle_state': 'lifecycleState',
            'created_by': 'createdBy',
            'execution_recurrences': 'executionRecurrences',
            'task_details': 'taskDetails',
            'time_created': 'timeCreated',
            'time_last_run': 'timeLastRun',
            'time_next_run': 'timeNextRun',
            'time_last_updated': 'timeLastUpdated'
        }
        self._id = None
        self._fleet_id = None
        self._name = None
        self._lifecycle_state = None
        self._created_by = None
        self._execution_recurrences = None
        self._task_details = None
        self._time_created = None
        self._time_last_run = None
        self._time_next_run = None
        self._time_last_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this TaskScheduleSummary.
        The `OCID`__ to identify this task schedule.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this TaskScheduleSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TaskScheduleSummary.
        The `OCID`__ to identify this task schedule.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this TaskScheduleSummary.
        :type: str
        """
        self._id = id

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this TaskScheduleSummary.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this TaskScheduleSummary.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this TaskScheduleSummary.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this TaskScheduleSummary.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this TaskScheduleSummary.
        The name of the task schedule.


        :return: The name of this TaskScheduleSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TaskScheduleSummary.
        The name of the task schedule.


        :param name: The name of this TaskScheduleSummary.
        :type: str
        """
        self._name = name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this TaskScheduleSummary.
        The current state of the task schedule.


        :return: The lifecycle_state of this TaskScheduleSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this TaskScheduleSummary.
        The current state of the task schedule.


        :param lifecycle_state: The lifecycle_state of this TaskScheduleSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this TaskScheduleSummary.
        The name of the task creator.


        :return: The created_by of this TaskScheduleSummary.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this TaskScheduleSummary.
        The name of the task creator.


        :param created_by: The created_by of this TaskScheduleSummary.
        :type: str
        """
        self._created_by = created_by

    @property
    def execution_recurrences(self):
        """
        **[Required]** Gets the execution_recurrences of this TaskScheduleSummary.
        Recurrence specification for the task schedule execution (formatted according to `RFC-5545`__). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000
        RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.

        __ https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/


        :return: The execution_recurrences of this TaskScheduleSummary.
        :rtype: str
        """
        return self._execution_recurrences

    @execution_recurrences.setter
    def execution_recurrences(self, execution_recurrences):
        """
        Sets the execution_recurrences of this TaskScheduleSummary.
        Recurrence specification for the task schedule execution (formatted according to `RFC-5545`__). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000
        RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.

        __ https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/


        :param execution_recurrences: The execution_recurrences of this TaskScheduleSummary.
        :type: str
        """
        self._execution_recurrences = execution_recurrences

    @property
    def task_details(self):
        """
        **[Required]** Gets the task_details of this TaskScheduleSummary.

        :return: The task_details of this TaskScheduleSummary.
        :rtype: oci.jms.models.TaskDetails
        """
        return self._task_details

    @task_details.setter
    def task_details(self, task_details):
        """
        Sets the task_details of this TaskScheduleSummary.

        :param task_details: The task_details of this TaskScheduleSummary.
        :type: oci.jms.models.TaskDetails
        """
        self._task_details = task_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this TaskScheduleSummary.
        The date and time the task schedule was created (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this TaskScheduleSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this TaskScheduleSummary.
        The date and time the task schedule was created (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this TaskScheduleSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_last_run(self):
        """
        Gets the time_last_run of this TaskScheduleSummary.
        The date and time the task schedule ran last (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_last_run of this TaskScheduleSummary.
        :rtype: datetime
        """
        return self._time_last_run

    @time_last_run.setter
    def time_last_run(self, time_last_run):
        """
        Sets the time_last_run of this TaskScheduleSummary.
        The date and time the task schedule ran last (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_last_run: The time_last_run of this TaskScheduleSummary.
        :type: datetime
        """
        self._time_last_run = time_last_run

    @property
    def time_next_run(self):
        """
        Gets the time_next_run of this TaskScheduleSummary.
        The date and time the task schedule will run next (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_next_run of this TaskScheduleSummary.
        :rtype: datetime
        """
        return self._time_next_run

    @time_next_run.setter
    def time_next_run(self, time_next_run):
        """
        Sets the time_next_run of this TaskScheduleSummary.
        The date and time the task schedule will run next (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_next_run: The time_next_run of this TaskScheduleSummary.
        :type: datetime
        """
        self._time_next_run = time_next_run

    @property
    def time_last_updated(self):
        """
        **[Required]** Gets the time_last_updated of this TaskScheduleSummary.
        The date and time the task schedule was last updated (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_last_updated of this TaskScheduleSummary.
        :rtype: datetime
        """
        return self._time_last_updated

    @time_last_updated.setter
    def time_last_updated(self, time_last_updated):
        """
        Sets the time_last_updated of this TaskScheduleSummary.
        The date and time the task schedule was last updated (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_last_updated: The time_last_updated of this TaskScheduleSummary.
        :type: datetime
        """
        self._time_last_updated = time_last_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
