# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaMigrationAnalysisTarget(object):
    """
    The target for the Java Migration Analysis
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JavaMigrationAnalysisTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this JavaMigrationAnalysisTarget.
        :type analysis_project_name: str

        :param input_applications_object_storage_paths:
            The value to assign to the input_applications_object_storage_paths property of this JavaMigrationAnalysisTarget.
        :type input_applications_object_storage_paths: list[str]

        :param target_jdk_versions:
            The value to assign to the target_jdk_versions property of this JavaMigrationAnalysisTarget.
        :type target_jdk_versions: list[str]

        :param include_package_prefixes:
            The value to assign to the include_package_prefixes property of this JavaMigrationAnalysisTarget.
        :type include_package_prefixes: list[str]

        :param exclude_package_prefixes:
            The value to assign to the exclude_package_prefixes property of this JavaMigrationAnalysisTarget.
        :type exclude_package_prefixes: list[str]

        """
        self.swagger_types = {
            'analysis_project_name': 'str',
            'input_applications_object_storage_paths': 'list[str]',
            'target_jdk_versions': 'list[str]',
            'include_package_prefixes': 'list[str]',
            'exclude_package_prefixes': 'list[str]'
        }
        self.attribute_map = {
            'analysis_project_name': 'analysisProjectName',
            'input_applications_object_storage_paths': 'inputApplicationsObjectStoragePaths',
            'target_jdk_versions': 'targetJdkVersions',
            'include_package_prefixes': 'includePackagePrefixes',
            'exclude_package_prefixes': 'excludePackagePrefixes'
        }
        self._analysis_project_name = None
        self._input_applications_object_storage_paths = None
        self._target_jdk_versions = None
        self._include_package_prefixes = None
        self._exclude_package_prefixes = None

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this JavaMigrationAnalysisTarget.
        Name of the analysis project.


        :return: The analysis_project_name of this JavaMigrationAnalysisTarget.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this JavaMigrationAnalysisTarget.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this JavaMigrationAnalysisTarget.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    @property
    def input_applications_object_storage_paths(self):
        """
        **[Required]** Gets the input_applications_object_storage_paths of this JavaMigrationAnalysisTarget.
        Object storage paths to the input files applications to be analysed.


        :return: The input_applications_object_storage_paths of this JavaMigrationAnalysisTarget.
        :rtype: list[str]
        """
        return self._input_applications_object_storage_paths

    @input_applications_object_storage_paths.setter
    def input_applications_object_storage_paths(self, input_applications_object_storage_paths):
        """
        Sets the input_applications_object_storage_paths of this JavaMigrationAnalysisTarget.
        Object storage paths to the input files applications to be analysed.


        :param input_applications_object_storage_paths: The input_applications_object_storage_paths of this JavaMigrationAnalysisTarget.
        :type: list[str]
        """
        self._input_applications_object_storage_paths = input_applications_object_storage_paths

    @property
    def target_jdk_versions(self):
        """
        **[Required]** Gets the target_jdk_versions of this JavaMigrationAnalysisTarget.
        Version of the target JDKs.


        :return: The target_jdk_versions of this JavaMigrationAnalysisTarget.
        :rtype: list[str]
        """
        return self._target_jdk_versions

    @target_jdk_versions.setter
    def target_jdk_versions(self, target_jdk_versions):
        """
        Sets the target_jdk_versions of this JavaMigrationAnalysisTarget.
        Version of the target JDKs.


        :param target_jdk_versions: The target_jdk_versions of this JavaMigrationAnalysisTarget.
        :type: list[str]
        """
        self._target_jdk_versions = target_jdk_versions

    @property
    def include_package_prefixes(self):
        """
        Gets the include_package_prefixes of this JavaMigrationAnalysisTarget.
        Package prefixes to be included from the migration analysis. Either this or excludePackagePrefixes can be specified.


        :return: The include_package_prefixes of this JavaMigrationAnalysisTarget.
        :rtype: list[str]
        """
        return self._include_package_prefixes

    @include_package_prefixes.setter
    def include_package_prefixes(self, include_package_prefixes):
        """
        Sets the include_package_prefixes of this JavaMigrationAnalysisTarget.
        Package prefixes to be included from the migration analysis. Either this or excludePackagePrefixes can be specified.


        :param include_package_prefixes: The include_package_prefixes of this JavaMigrationAnalysisTarget.
        :type: list[str]
        """
        self._include_package_prefixes = include_package_prefixes

    @property
    def exclude_package_prefixes(self):
        """
        Gets the exclude_package_prefixes of this JavaMigrationAnalysisTarget.
        Package prefixes to be excluded from the migration analysis. Either this or includePackagePrefixes can be specified.


        :return: The exclude_package_prefixes of this JavaMigrationAnalysisTarget.
        :rtype: list[str]
        """
        return self._exclude_package_prefixes

    @exclude_package_prefixes.setter
    def exclude_package_prefixes(self, exclude_package_prefixes):
        """
        Sets the exclude_package_prefixes of this JavaMigrationAnalysisTarget.
        Package prefixes to be excluded from the migration analysis. Either this or includePackagePrefixes can be specified.


        :param exclude_package_prefixes: The exclude_package_prefixes of this JavaMigrationAnalysisTarget.
        :type: list[str]
        """
        self._exclude_package_prefixes = exclude_package_prefixes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
