# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateVaultReplicaDetails(object):
    """
    Creates a vault replica.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateVaultReplicaDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param replica_region:
            The value to assign to the replica_region property of this CreateVaultReplicaDetails.
        :type replica_region: str

        :param replica_vault_metadata:
            The value to assign to the replica_vault_metadata property of this CreateVaultReplicaDetails.
        :type replica_vault_metadata: oci.key_management.models.ReplicaVaultMetadata

        """
        self.swagger_types = {
            'replica_region': 'str',
            'replica_vault_metadata': 'ReplicaVaultMetadata'
        }
        self.attribute_map = {
            'replica_region': 'replicaRegion',
            'replica_vault_metadata': 'replicaVaultMetadata'
        }
        self._replica_region = None
        self._replica_vault_metadata = None

    @property
    def replica_region(self):
        """
        **[Required]** Gets the replica_region of this CreateVaultReplicaDetails.
        The region in the realm to which the vault need to be replicated to


        :return: The replica_region of this CreateVaultReplicaDetails.
        :rtype: str
        """
        return self._replica_region

    @replica_region.setter
    def replica_region(self, replica_region):
        """
        Sets the replica_region of this CreateVaultReplicaDetails.
        The region in the realm to which the vault need to be replicated to


        :param replica_region: The replica_region of this CreateVaultReplicaDetails.
        :type: str
        """
        self._replica_region = replica_region

    @property
    def replica_vault_metadata(self):
        """
        Gets the replica_vault_metadata of this CreateVaultReplicaDetails.

        :return: The replica_vault_metadata of this CreateVaultReplicaDetails.
        :rtype: oci.key_management.models.ReplicaVaultMetadata
        """
        return self._replica_vault_metadata

    @replica_vault_metadata.setter
    def replica_vault_metadata(self, replica_vault_metadata):
        """
        Sets the replica_vault_metadata of this CreateVaultReplicaDetails.

        :param replica_vault_metadata: The replica_vault_metadata of this CreateVaultReplicaDetails.
        :type: oci.key_management.models.ReplicaVaultMetadata
        """
        self._replica_vault_metadata = replica_vault_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
