# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericConditionBlock(object):
    """
    A condition block. This could represent a single condition, or have nested condition blocks under it.
    To form a single condition, specify the name, operator and value(s).
    To form nested conditions, specify the conditions in conditionBlocks, and how to join them in conditionBlocksOperator.
    """

    #: A constant which can be used with the condition_blocks_operator property of a GenericConditionBlock.
    #: This constant has a value of "AND"
    CONDITION_BLOCKS_OPERATOR_AND = "AND"

    #: A constant which can be used with the condition_blocks_operator property of a GenericConditionBlock.
    #: This constant has a value of "OR"
    CONDITION_BLOCKS_OPERATOR_OR = "OR"

    #: A constant which can be used with the condition_blocks_operator property of a GenericConditionBlock.
    #: This constant has a value of "NOT_AND"
    CONDITION_BLOCKS_OPERATOR_NOT_AND = "NOT_AND"

    #: A constant which can be used with the condition_blocks_operator property of a GenericConditionBlock.
    #: This constant has a value of "NOT_OR"
    CONDITION_BLOCKS_OPERATOR_NOT_OR = "NOT_OR"

    def __init__(self, **kwargs):
        """
        Initializes a new GenericConditionBlock object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param condition_blocks_operator:
            The value to assign to the condition_blocks_operator property of this GenericConditionBlock.
            Allowed values for this property are: "AND", "OR", "NOT_AND", "NOT_OR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type condition_blocks_operator: str

        :param name:
            The value to assign to the name property of this GenericConditionBlock.
        :type name: str

        :param operator:
            The value to assign to the operator property of this GenericConditionBlock.
        :type operator: str

        :param value:
            The value to assign to the value property of this GenericConditionBlock.
        :type value: str

        :param values:
            The value to assign to the values property of this GenericConditionBlock.
        :type values: list[str]

        :param generic_condition_blocks:
            The value to assign to the generic_condition_blocks property of this GenericConditionBlock.
        :type generic_condition_blocks: list[oci.log_analytics.models.GenericConditionBlock]

        """
        self.swagger_types = {
            'condition_blocks_operator': 'str',
            'name': 'str',
            'operator': 'str',
            'value': 'str',
            'values': 'list[str]',
            'generic_condition_blocks': 'list[GenericConditionBlock]'
        }
        self.attribute_map = {
            'condition_blocks_operator': 'conditionBlocksOperator',
            'name': 'name',
            'operator': 'operator',
            'value': 'value',
            'values': 'values',
            'generic_condition_blocks': 'genericConditionBlocks'
        }
        self._condition_blocks_operator = None
        self._name = None
        self._operator = None
        self._value = None
        self._values = None
        self._generic_condition_blocks = None

    @property
    def condition_blocks_operator(self):
        """
        Gets the condition_blocks_operator of this GenericConditionBlock.
        Operator using which the conditionBlocks should be joined. Specify this for nested conditions.

        Allowed values for this property are: "AND", "OR", "NOT_AND", "NOT_OR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The condition_blocks_operator of this GenericConditionBlock.
        :rtype: str
        """
        return self._condition_blocks_operator

    @condition_blocks_operator.setter
    def condition_blocks_operator(self, condition_blocks_operator):
        """
        Sets the condition_blocks_operator of this GenericConditionBlock.
        Operator using which the conditionBlocks should be joined. Specify this for nested conditions.


        :param condition_blocks_operator: The condition_blocks_operator of this GenericConditionBlock.
        :type: str
        """
        allowed_values = ["AND", "OR", "NOT_AND", "NOT_OR"]
        if not value_allowed_none_or_none_sentinel(condition_blocks_operator, allowed_values):
            condition_blocks_operator = 'UNKNOWN_ENUM_VALUE'
        self._condition_blocks_operator = condition_blocks_operator

    @property
    def name(self):
        """
        Gets the name of this GenericConditionBlock.
        The name of the field the condition is based on. Specify this if this condition block represents a single condition.


        :return: The name of this GenericConditionBlock.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this GenericConditionBlock.
        The name of the field the condition is based on. Specify this if this condition block represents a single condition.


        :param name: The name of this GenericConditionBlock.
        :type: str
        """
        self._name = name

    @property
    def operator(self):
        """
        Gets the operator of this GenericConditionBlock.
        The condition operator. Specify this if this condition block represents a single condition.


        :return: The operator of this GenericConditionBlock.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this GenericConditionBlock.
        The condition operator. Specify this if this condition block represents a single condition.


        :param operator: The operator of this GenericConditionBlock.
        :type: str
        """
        self._operator = operator

    @property
    def value(self):
        """
        Gets the value of this GenericConditionBlock.
        The condition value. Specify this if this condition block represents a single condition.


        :return: The value of this GenericConditionBlock.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this GenericConditionBlock.
        The condition value. Specify this if this condition block represents a single condition.


        :param value: The value of this GenericConditionBlock.
        :type: str
        """
        self._value = value

    @property
    def values(self):
        """
        Gets the values of this GenericConditionBlock.
        A list of condition values. Specify this if this condition block represents a single condition.


        :return: The values of this GenericConditionBlock.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this GenericConditionBlock.
        A list of condition values. Specify this if this condition block represents a single condition.


        :param values: The values of this GenericConditionBlock.
        :type: list[str]
        """
        self._values = values

    @property
    def generic_condition_blocks(self):
        """
        Gets the generic_condition_blocks of this GenericConditionBlock.
        Condition blocks to evaluate within this condition block. Specify this for nested conditions.


        :return: The generic_condition_blocks of this GenericConditionBlock.
        :rtype: list[oci.log_analytics.models.GenericConditionBlock]
        """
        return self._generic_condition_blocks

    @generic_condition_blocks.setter
    def generic_condition_blocks(self, generic_condition_blocks):
        """
        Sets the generic_condition_blocks of this GenericConditionBlock.
        Condition blocks to evaluate within this condition block. Specify this for nested conditions.


        :param generic_condition_blocks: The generic_condition_blocks of this GenericConditionBlock.
        :type: list[oci.log_analytics.models.GenericConditionBlock]
        """
        self._generic_condition_blocks = generic_condition_blocks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
