# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601

from .abstract_command_descriptor import AbstractCommandDescriptor
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModuleCommandDescriptor(AbstractCommandDescriptor):
    """
    Command descriptor for querylanguage MODULE command.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModuleCommandDescriptor object with values from keyword arguments. The default value of the :py:attr:`~oci.log_analytics.models.ModuleCommandDescriptor.name` attribute
        of this class is ``MODULE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ModuleCommandDescriptor.
            Allowed values for this property are: "COMMAND", "SEARCH", "STATS", "GEO_STATS", "TIME_STATS", "SORT", "FIELDS", "ADD_FIELDS", "LINK", "LINK_DETAILS", "CLUSTER", "CLUSTER_DETAILS", "CLUSTER_SPLIT", "EVAL", "EXTRACT", "JSON_EXTRACT", "XML_EXTRACT", "EVENT_STATS", "BUCKET", "CLASSIFY", "TOP", "BOTTOM", "HEAD", "TAIL", "FIELD_SUMMARY", "REGEX", "RENAME", "TIME_COMPARE", "WHERE", "CLUSTER_COMPARE", "DELETE", "CREATETABLE", "SEQUENCE", "UPDATETABLE", "DELTA", "DISTINCT", "SEARCH_LOOKUP", "LOOKUP", "DEMO_MODE", "MACRO", "MODULE", "MULTI_SEARCH", "HIGHLIGHT", "HIGHLIGHT_ROWS", "HIGHLIGHT_GROUPS", "CREATE_VIEW", "MAP", "NLP", "COMPARE", "ADD_INSIGHTS", "ANOMALY", "DEDUP", "TIME_CLUSTER", "FREQUENT", "RARE", "OUTLIER"
        :type name: str

        :param display_query_string:
            The value to assign to the display_query_string property of this ModuleCommandDescriptor.
        :type display_query_string: str

        :param internal_query_string:
            The value to assign to the internal_query_string property of this ModuleCommandDescriptor.
        :type internal_query_string: str

        :param category:
            The value to assign to the category property of this ModuleCommandDescriptor.
        :type category: str

        :param referenced_fields:
            The value to assign to the referenced_fields property of this ModuleCommandDescriptor.
        :type referenced_fields: list[oci.log_analytics.models.AbstractField]

        :param declared_fields:
            The value to assign to the declared_fields property of this ModuleCommandDescriptor.
        :type declared_fields: list[oci.log_analytics.models.AbstractField]

        :param is_hidden:
            The value to assign to the is_hidden property of this ModuleCommandDescriptor.
        :type is_hidden: bool

        :param description:
            The value to assign to the description property of this ModuleCommandDescriptor.
        :type description: str

        :param example:
            The value to assign to the example property of this ModuleCommandDescriptor.
        :type example: str

        :param properties:
            The value to assign to the properties property of this ModuleCommandDescriptor.
        :type properties: list[oci.log_analytics.models.PropertyDefinition]

        :param arguments:
            The value to assign to the arguments property of this ModuleCommandDescriptor.
        :type arguments: list[oci.log_analytics.models.VariableDefinition]

        """
        self.swagger_types = {
            'name': 'str',
            'display_query_string': 'str',
            'internal_query_string': 'str',
            'category': 'str',
            'referenced_fields': 'list[AbstractField]',
            'declared_fields': 'list[AbstractField]',
            'is_hidden': 'bool',
            'description': 'str',
            'example': 'str',
            'properties': 'list[PropertyDefinition]',
            'arguments': 'list[VariableDefinition]'
        }
        self.attribute_map = {
            'name': 'name',
            'display_query_string': 'displayQueryString',
            'internal_query_string': 'internalQueryString',
            'category': 'category',
            'referenced_fields': 'referencedFields',
            'declared_fields': 'declaredFields',
            'is_hidden': 'isHidden',
            'description': 'description',
            'example': 'example',
            'properties': 'properties',
            'arguments': 'arguments'
        }
        self._name = None
        self._display_query_string = None
        self._internal_query_string = None
        self._category = None
        self._referenced_fields = None
        self._declared_fields = None
        self._is_hidden = None
        self._description = None
        self._example = None
        self._properties = None
        self._arguments = None
        self._name = 'MODULE'

    @property
    def description(self):
        """
        Gets the description of this ModuleCommandDescriptor.
        Description of the macro.


        :return: The description of this ModuleCommandDescriptor.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ModuleCommandDescriptor.
        Description of the macro.


        :param description: The description of this ModuleCommandDescriptor.
        :type: str
        """
        self._description = description

    @property
    def example(self):
        """
        Gets the example of this ModuleCommandDescriptor.
        Description of the macro.


        :return: The example of this ModuleCommandDescriptor.
        :rtype: str
        """
        return self._example

    @example.setter
    def example(self, example):
        """
        Sets the example of this ModuleCommandDescriptor.
        Description of the macro.


        :param example: The example of this ModuleCommandDescriptor.
        :type: str
        """
        self._example = example

    @property
    def properties(self):
        """
        Gets the properties of this ModuleCommandDescriptor.
        Optional list of properties for the macro.


        :return: The properties of this ModuleCommandDescriptor.
        :rtype: list[oci.log_analytics.models.PropertyDefinition]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this ModuleCommandDescriptor.
        Optional list of properties for the macro.


        :param properties: The properties of this ModuleCommandDescriptor.
        :type: list[oci.log_analytics.models.PropertyDefinition]
        """
        self._properties = properties

    @property
    def arguments(self):
        """
        Gets the arguments of this ModuleCommandDescriptor.
        Optional list of arguments used in the macro.


        :return: The arguments of this ModuleCommandDescriptor.
        :rtype: list[oci.log_analytics.models.VariableDefinition]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this ModuleCommandDescriptor.
        Optional list of arguments used in the macro.


        :param arguments: The arguments of this ModuleCommandDescriptor.
        :type: list[oci.log_analytics.models.VariableDefinition]
        """
        self._arguments = arguments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
