# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateLustreFileSystemDetails(object):
    """
    The details to create a Lustre file system.
    """

    #: A constant which can be used with the performance_tier property of a CreateLustreFileSystemDetails.
    #: This constant has a value of "MBPS_PER_TB_125"
    PERFORMANCE_TIER_MBPS_PER_TB_125 = "MBPS_PER_TB_125"

    #: A constant which can be used with the performance_tier property of a CreateLustreFileSystemDetails.
    #: This constant has a value of "MBPS_PER_TB_250"
    PERFORMANCE_TIER_MBPS_PER_TB_250 = "MBPS_PER_TB_250"

    #: A constant which can be used with the performance_tier property of a CreateLustreFileSystemDetails.
    #: This constant has a value of "MBPS_PER_TB_500"
    PERFORMANCE_TIER_MBPS_PER_TB_500 = "MBPS_PER_TB_500"

    #: A constant which can be used with the performance_tier property of a CreateLustreFileSystemDetails.
    #: This constant has a value of "MBPS_PER_TB_1000"
    PERFORMANCE_TIER_MBPS_PER_TB_1000 = "MBPS_PER_TB_1000"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateLustreFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateLustreFileSystemDetails.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateLustreFileSystemDetails.
        :type availability_domain: str

        :param display_name:
            The value to assign to the display_name property of this CreateLustreFileSystemDetails.
        :type display_name: str

        :param file_system_description:
            The value to assign to the file_system_description property of this CreateLustreFileSystemDetails.
        :type file_system_description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateLustreFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateLustreFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateLustreFileSystemDetails.
        :type nsg_ids: list[str]

        :param file_system_name:
            The value to assign to the file_system_name property of this CreateLustreFileSystemDetails.
        :type file_system_name: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateLustreFileSystemDetails.
        :type kms_key_id: str

        :param capacity_in_gbs:
            The value to assign to the capacity_in_gbs property of this CreateLustreFileSystemDetails.
        :type capacity_in_gbs: int

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateLustreFileSystemDetails.
        :type subnet_id: str

        :param performance_tier:
            The value to assign to the performance_tier property of this CreateLustreFileSystemDetails.
            Allowed values for this property are: "MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000"
        :type performance_tier: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this CreateLustreFileSystemDetails.
        :type cluster_placement_group_id: str

        :param root_squash_configuration:
            The value to assign to the root_squash_configuration property of this CreateLustreFileSystemDetails.
        :type root_squash_configuration: oci.lustre_file_storage.models.RootSquashConfiguration

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'availability_domain': 'str',
            'display_name': 'str',
            'file_system_description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'nsg_ids': 'list[str]',
            'file_system_name': 'str',
            'kms_key_id': 'str',
            'capacity_in_gbs': 'int',
            'subnet_id': 'str',
            'performance_tier': 'str',
            'cluster_placement_group_id': 'str',
            'root_squash_configuration': 'RootSquashConfiguration'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'display_name': 'displayName',
            'file_system_description': 'fileSystemDescription',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'nsg_ids': 'nsgIds',
            'file_system_name': 'fileSystemName',
            'kms_key_id': 'kmsKeyId',
            'capacity_in_gbs': 'capacityInGBs',
            'subnet_id': 'subnetId',
            'performance_tier': 'performanceTier',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'root_squash_configuration': 'rootSquashConfiguration'
        }
        self._compartment_id = None
        self._availability_domain = None
        self._display_name = None
        self._file_system_description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._nsg_ids = None
        self._file_system_name = None
        self._kms_key_id = None
        self._capacity_in_gbs = None
        self._subnet_id = None
        self._performance_tier = None
        self._cluster_placement_group_id = None
        self._root_squash_configuration = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateLustreFileSystemDetails.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateLustreFileSystemDetails.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateLustreFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Lustre file system`


        :return: The display_name of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateLustreFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Lustre file system`


        :param display_name: The display_name of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def file_system_description(self):
        """
        Gets the file_system_description of this CreateLustreFileSystemDetails.
        Short description of the Lustre file system.
        Avoid entering confidential information.


        :return: The file_system_description of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._file_system_description

    @file_system_description.setter
    def file_system_description(self, file_system_description):
        """
        Sets the file_system_description of this CreateLustreFileSystemDetails.
        Short description of the Lustre file system.
        Avoid entering confidential information.


        :param file_system_description: The file_system_description of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._file_system_description = file_system_description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateLustreFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateLustreFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateLustreFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateLustreFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateLustreFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateLustreFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateLustreFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateLustreFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateLustreFileSystemDetails.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this CreateLustreFileSystemDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateLustreFileSystemDetails.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this CreateLustreFileSystemDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def file_system_name(self):
        """
        **[Required]** Gets the file_system_name of this CreateLustreFileSystemDetails.
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface.
        The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.


        :return: The file_system_name of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._file_system_name

    @file_system_name.setter
    def file_system_name(self, file_system_name):
        """
        Sets the file_system_name of this CreateLustreFileSystemDetails.
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface.
        The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        If you have multiple Lustre file systems mounted on the same clients, this name can help distinguish them.


        :param file_system_name: The file_system_name of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._file_system_name = file_system_name

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The kms_key_id of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param kms_key_id: The kms_key_id of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def capacity_in_gbs(self):
        """
        **[Required]** Gets the capacity_in_gbs of this CreateLustreFileSystemDetails.
        Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.


        :return: The capacity_in_gbs of this CreateLustreFileSystemDetails.
        :rtype: int
        """
        return self._capacity_in_gbs

    @capacity_in_gbs.setter
    def capacity_in_gbs(self, capacity_in_gbs):
        """
        Sets the capacity_in_gbs of this CreateLustreFileSystemDetails.
        Capacity of the Lustre file system in GB. You can increase capacity only in multiples of 5 TB.


        :param capacity_in_gbs: The capacity_in_gbs of this CreateLustreFileSystemDetails.
        :type: int
        """
        self._capacity_in_gbs = capacity_in_gbs

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the subnet the Lustre file system is in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the subnet the Lustre file system is in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def performance_tier(self):
        """
        **[Required]** Gets the performance_tier of this CreateLustreFileSystemDetails.
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.

        Allowed values for this property are: "MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000"


        :return: The performance_tier of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._performance_tier

    @performance_tier.setter
    def performance_tier(self, performance_tier):
        """
        Sets the performance_tier of this CreateLustreFileSystemDetails.
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.


        :param performance_tier: The performance_tier of this CreateLustreFileSystemDetails.
        :type: str
        """
        allowed_values = ["MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000"]
        if not value_allowed_none_or_none_sentinel(performance_tier, allowed_values):
            raise ValueError(
                f"Invalid value for `performance_tier`, must be None or one of {allowed_values}"
            )
        self._performance_tier = performance_tier

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the cluster placement group in which the Lustre file system exists.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_placement_group_id of this CreateLustreFileSystemDetails.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this CreateLustreFileSystemDetails.
        The `OCID`__ of the cluster placement group in which the Lustre file system exists.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_placement_group_id: The cluster_placement_group_id of this CreateLustreFileSystemDetails.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def root_squash_configuration(self):
        """
        **[Required]** Gets the root_squash_configuration of this CreateLustreFileSystemDetails.

        :return: The root_squash_configuration of this CreateLustreFileSystemDetails.
        :rtype: oci.lustre_file_storage.models.RootSquashConfiguration
        """
        return self._root_squash_configuration

    @root_squash_configuration.setter
    def root_squash_configuration(self, root_squash_configuration):
        """
        Sets the root_squash_configuration of this CreateLustreFileSystemDetails.

        :param root_squash_configuration: The root_squash_configuration of this CreateLustreFileSystemDetails.
        :type: oci.lustre_file_storage.models.RootSquashConfiguration
        """
        self._root_squash_configuration = root_squash_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
