# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KafkaCluster(object):
    """
    A KafkaCluster is a description of a KafkaCluster.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a KafkaCluster.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the cluster_type property of a KafkaCluster.
    #: This constant has a value of "DEVELOPMENT"
    CLUSTER_TYPE_DEVELOPMENT = "DEVELOPMENT"

    #: A constant which can be used with the cluster_type property of a KafkaCluster.
    #: This constant has a value of "PRODUCTION"
    CLUSTER_TYPE_PRODUCTION = "PRODUCTION"

    #: A constant which can be used with the coordination_type property of a KafkaCluster.
    #: This constant has a value of "ZOOKEEPER"
    COORDINATION_TYPE_ZOOKEEPER = "ZOOKEEPER"

    #: A constant which can be used with the coordination_type property of a KafkaCluster.
    #: This constant has a value of "KRAFT"
    COORDINATION_TYPE_KRAFT = "KRAFT"

    def __init__(self, **kwargs):
        """
        Initializes a new KafkaCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this KafkaCluster.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this KafkaCluster.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this KafkaCluster.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this KafkaCluster.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this KafkaCluster.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this KafkaCluster.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this KafkaCluster.
        :type lifecycle_details: str

        :param access_subnets:
            The value to assign to the access_subnets property of this KafkaCluster.
        :type access_subnets: list[oci.managed_kafka.models.SubnetSet]

        :param client_certificate_bundle:
            The value to assign to the client_certificate_bundle property of this KafkaCluster.
        :type client_certificate_bundle: str

        :param kafka_version:
            The value to assign to the kafka_version property of this KafkaCluster.
        :type kafka_version: str

        :param cluster_type:
            The value to assign to the cluster_type property of this KafkaCluster.
            Allowed values for this property are: "DEVELOPMENT", "PRODUCTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_type: str

        :param broker_shape:
            The value to assign to the broker_shape property of this KafkaCluster.
        :type broker_shape: oci.managed_kafka.models.BrokerShape

        :param cluster_config_id:
            The value to assign to the cluster_config_id property of this KafkaCluster.
        :type cluster_config_id: str

        :param cluster_config_version:
            The value to assign to the cluster_config_version property of this KafkaCluster.
        :type cluster_config_version: int

        :param kafka_bootstrap_urls:
            The value to assign to the kafka_bootstrap_urls property of this KafkaCluster.
        :type kafka_bootstrap_urls: list[oci.managed_kafka.models.BootstrapUrl]

        :param coordination_type:
            The value to assign to the coordination_type property of this KafkaCluster.
            Allowed values for this property are: "ZOOKEEPER", "KRAFT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type coordination_type: str

        :param secret_id:
            The value to assign to the secret_id property of this KafkaCluster.
        :type secret_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this KafkaCluster.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this KafkaCluster.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this KafkaCluster.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'access_subnets': 'list[SubnetSet]',
            'client_certificate_bundle': 'str',
            'kafka_version': 'str',
            'cluster_type': 'str',
            'broker_shape': 'BrokerShape',
            'cluster_config_id': 'str',
            'cluster_config_version': 'int',
            'kafka_bootstrap_urls': 'list[BootstrapUrl]',
            'coordination_type': 'str',
            'secret_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'access_subnets': 'accessSubnets',
            'client_certificate_bundle': 'clientCertificateBundle',
            'kafka_version': 'kafkaVersion',
            'cluster_type': 'clusterType',
            'broker_shape': 'brokerShape',
            'cluster_config_id': 'clusterConfigId',
            'cluster_config_version': 'clusterConfigVersion',
            'kafka_bootstrap_urls': 'kafkaBootstrapUrls',
            'coordination_type': 'coordinationType',
            'secret_id': 'secretId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._access_subnets = None
        self._client_certificate_bundle = None
        self._kafka_version = None
        self._cluster_type = None
        self._broker_shape = None
        self._cluster_config_id = None
        self._cluster_config_version = None
        self._kafka_bootstrap_urls = None
        self._coordination_type = None
        self._secret_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this KafkaCluster.
        The `OCID`__ of the KafkaCluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this KafkaCluster.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KafkaCluster.
        The `OCID`__ of the KafkaCluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this KafkaCluster.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this KafkaCluster.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this KafkaCluster.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this KafkaCluster.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this KafkaCluster.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this KafkaCluster.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this KafkaCluster.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this KafkaCluster.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this KafkaCluster.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this KafkaCluster.
        The date and time the KafkaCluster was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this KafkaCluster.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this KafkaCluster.
        The date and time the KafkaCluster was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this KafkaCluster.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this KafkaCluster.
        The date and time the KafkaCluster was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this KafkaCluster.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this KafkaCluster.
        The date and time the KafkaCluster was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this KafkaCluster.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this KafkaCluster.
        The current state of the KafkaCluster.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this KafkaCluster.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this KafkaCluster.
        The current state of the KafkaCluster.


        :param lifecycle_state: The lifecycle_state of this KafkaCluster.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this KafkaCluster.
        A message that describes the current state of the KafkaCluster in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this KafkaCluster.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this KafkaCluster.
        A message that describes the current state of the KafkaCluster in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this KafkaCluster.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def access_subnets(self):
        """
        **[Required]** Gets the access_subnets of this KafkaCluster.
        Subnets where broker/coordinator VNICs will be created.


        :return: The access_subnets of this KafkaCluster.
        :rtype: list[oci.managed_kafka.models.SubnetSet]
        """
        return self._access_subnets

    @access_subnets.setter
    def access_subnets(self, access_subnets):
        """
        Sets the access_subnets of this KafkaCluster.
        Subnets where broker/coordinator VNICs will be created.


        :param access_subnets: The access_subnets of this KafkaCluster.
        :type: list[oci.managed_kafka.models.SubnetSet]
        """
        self._access_subnets = access_subnets

    @property
    def client_certificate_bundle(self):
        """
        Gets the client_certificate_bundle of this KafkaCluster.
        CA certificate bundle for mTLS broker authentication.


        :return: The client_certificate_bundle of this KafkaCluster.
        :rtype: str
        """
        return self._client_certificate_bundle

    @client_certificate_bundle.setter
    def client_certificate_bundle(self, client_certificate_bundle):
        """
        Sets the client_certificate_bundle of this KafkaCluster.
        CA certificate bundle for mTLS broker authentication.


        :param client_certificate_bundle: The client_certificate_bundle of this KafkaCluster.
        :type: str
        """
        self._client_certificate_bundle = client_certificate_bundle

    @property
    def kafka_version(self):
        """
        **[Required]** Gets the kafka_version of this KafkaCluster.
        Version of Kafka to use to spin up the cluster


        :return: The kafka_version of this KafkaCluster.
        :rtype: str
        """
        return self._kafka_version

    @kafka_version.setter
    def kafka_version(self, kafka_version):
        """
        Sets the kafka_version of this KafkaCluster.
        Version of Kafka to use to spin up the cluster


        :param kafka_version: The kafka_version of this KafkaCluster.
        :type: str
        """
        self._kafka_version = kafka_version

    @property
    def cluster_type(self):
        """
        **[Required]** Gets the cluster_type of this KafkaCluster.
        Type of the cluster to spin up.
        DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on a single node
        PRODUCTION - Minimum allowed broker count is 3

        Allowed values for this property are: "DEVELOPMENT", "PRODUCTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_type of this KafkaCluster.
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """
        Sets the cluster_type of this KafkaCluster.
        Type of the cluster to spin up.
        DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on a single node
        PRODUCTION - Minimum allowed broker count is 3


        :param cluster_type: The cluster_type of this KafkaCluster.
        :type: str
        """
        allowed_values = ["DEVELOPMENT", "PRODUCTION"]
        if not value_allowed_none_or_none_sentinel(cluster_type, allowed_values):
            cluster_type = 'UNKNOWN_ENUM_VALUE'
        self._cluster_type = cluster_type

    @property
    def broker_shape(self):
        """
        **[Required]** Gets the broker_shape of this KafkaCluster.

        :return: The broker_shape of this KafkaCluster.
        :rtype: oci.managed_kafka.models.BrokerShape
        """
        return self._broker_shape

    @broker_shape.setter
    def broker_shape(self, broker_shape):
        """
        Sets the broker_shape of this KafkaCluster.

        :param broker_shape: The broker_shape of this KafkaCluster.
        :type: oci.managed_kafka.models.BrokerShape
        """
        self._broker_shape = broker_shape

    @property
    def cluster_config_id(self):
        """
        **[Required]** Gets the cluster_config_id of this KafkaCluster.
        The `OCID`__ of Kafka Cluster configuration object

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The cluster_config_id of this KafkaCluster.
        :rtype: str
        """
        return self._cluster_config_id

    @cluster_config_id.setter
    def cluster_config_id(self, cluster_config_id):
        """
        Sets the cluster_config_id of this KafkaCluster.
        The `OCID`__ of Kafka Cluster configuration object

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param cluster_config_id: The cluster_config_id of this KafkaCluster.
        :type: str
        """
        self._cluster_config_id = cluster_config_id

    @property
    def cluster_config_version(self):
        """
        **[Required]** Gets the cluster_config_version of this KafkaCluster.
        The version of configuration object


        :return: The cluster_config_version of this KafkaCluster.
        :rtype: int
        """
        return self._cluster_config_version

    @cluster_config_version.setter
    def cluster_config_version(self, cluster_config_version):
        """
        Sets the cluster_config_version of this KafkaCluster.
        The version of configuration object


        :param cluster_config_version: The cluster_config_version of this KafkaCluster.
        :type: int
        """
        self._cluster_config_version = cluster_config_version

    @property
    def kafka_bootstrap_urls(self):
        """
        Gets the kafka_bootstrap_urls of this KafkaCluster.
        Bootstrap URL that can be used to connect to Kafka


        :return: The kafka_bootstrap_urls of this KafkaCluster.
        :rtype: list[oci.managed_kafka.models.BootstrapUrl]
        """
        return self._kafka_bootstrap_urls

    @kafka_bootstrap_urls.setter
    def kafka_bootstrap_urls(self, kafka_bootstrap_urls):
        """
        Sets the kafka_bootstrap_urls of this KafkaCluster.
        Bootstrap URL that can be used to connect to Kafka


        :param kafka_bootstrap_urls: The kafka_bootstrap_urls of this KafkaCluster.
        :type: list[oci.managed_kafka.models.BootstrapUrl]
        """
        self._kafka_bootstrap_urls = kafka_bootstrap_urls

    @property
    def coordination_type(self):
        """
        Gets the coordination_type of this KafkaCluster.
        Kafka coordination type. Set of available types depends on Kafka version

        Allowed values for this property are: "ZOOKEEPER", "KRAFT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The coordination_type of this KafkaCluster.
        :rtype: str
        """
        return self._coordination_type

    @coordination_type.setter
    def coordination_type(self, coordination_type):
        """
        Sets the coordination_type of this KafkaCluster.
        Kafka coordination type. Set of available types depends on Kafka version


        :param coordination_type: The coordination_type of this KafkaCluster.
        :type: str
        """
        allowed_values = ["ZOOKEEPER", "KRAFT"]
        if not value_allowed_none_or_none_sentinel(coordination_type, allowed_values):
            coordination_type = 'UNKNOWN_ENUM_VALUE'
        self._coordination_type = coordination_type

    @property
    def secret_id(self):
        """
        Gets the secret_id of this KafkaCluster.
        The `OCID`__ of the secret that contains superuser password.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The secret_id of this KafkaCluster.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this KafkaCluster.
        The `OCID`__ of the secret that contains superuser password.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param secret_id: The secret_id of this KafkaCluster.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this KafkaCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this KafkaCluster.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this KafkaCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this KafkaCluster.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this KafkaCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this KafkaCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this KafkaCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this KafkaCluster.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this KafkaCluster.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this KafkaCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this KafkaCluster.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this KafkaCluster.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
