# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DisbursementReportRecord(object):
    """
    The model for disbursement report item
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DisbursementReportRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param enterprise_quarter:
            The value to assign to the enterprise_quarter property of this DisbursementReportRecord.
        :type enterprise_quarter: str

        :param enterprise_period:
            The value to assign to the enterprise_period property of this DisbursementReportRecord.
        :type enterprise_period: str

        :param listing_name:
            The value to assign to the listing_name property of this DisbursementReportRecord.
        :type listing_name: str

        :param listing_id:
            The value to assign to the listing_id property of this DisbursementReportRecord.
        :type listing_id: str

        :param private_offer_id:
            The value to assign to the private_offer_id property of this DisbursementReportRecord.
        :type private_offer_id: str

        :param private_offer_name:
            The value to assign to the private_offer_name property of this DisbursementReportRecord.
        :type private_offer_name: str

        :param sku:
            The value to assign to the sku property of this DisbursementReportRecord.
        :type sku: str

        :param transaction_reference_id:
            The value to assign to the transaction_reference_id property of this DisbursementReportRecord.
        :type transaction_reference_id: str

        :param customer_id:
            The value to assign to the customer_id property of this DisbursementReportRecord.
        :type customer_id: str

        :param customer_name:
            The value to assign to the customer_name property of this DisbursementReportRecord.
        :type customer_name: str

        :param customer_domain:
            The value to assign to the customer_domain property of this DisbursementReportRecord.
        :type customer_domain: str

        :param end_user_customer_id:
            The value to assign to the end_user_customer_id property of this DisbursementReportRecord.
        :type end_user_customer_id: str

        :param end_user_customer_name:
            The value to assign to the end_user_customer_name property of this DisbursementReportRecord.
        :type end_user_customer_name: str

        :param country:
            The value to assign to the country property of this DisbursementReportRecord.
        :type country: str

        :param state:
            The value to assign to the state property of this DisbursementReportRecord.
        :type state: str

        :param city:
            The value to assign to the city property of this DisbursementReportRecord.
        :type city: str

        :param zip:
            The value to assign to the zip property of this DisbursementReportRecord.
        :type zip: str

        :param currency_code:
            The value to assign to the currency_code property of this DisbursementReportRecord.
        :type currency_code: str

        :param usage_quantity:
            The value to assign to the usage_quantity property of this DisbursementReportRecord.
        :type usage_quantity: str

        :param used_amount_lc:
            The value to assign to the used_amount_lc property of this DisbursementReportRecord.
        :type used_amount_lc: str

        :param lc_amount_for_disbursement_calculations:
            The value to assign to the lc_amount_for_disbursement_calculations property of this DisbursementReportRecord.
        :type lc_amount_for_disbursement_calculations: str

        :param lc_base_amount_for_tax_calculations:
            The value to assign to the lc_base_amount_for_tax_calculations property of this DisbursementReportRecord.
        :type lc_base_amount_for_tax_calculations: str

        :param withholding_tax_rate:
            The value to assign to the withholding_tax_rate property of this DisbursementReportRecord.
        :type withholding_tax_rate: str

        :param withholding_tax_amount:
            The value to assign to the withholding_tax_amount property of this DisbursementReportRecord.
        :type withholding_tax_amount: str

        :param transfer_tax_base_amount:
            The value to assign to the transfer_tax_base_amount property of this DisbursementReportRecord.
        :type transfer_tax_base_amount: str

        :param transfer_tax_rate:
            The value to assign to the transfer_tax_rate property of this DisbursementReportRecord.
        :type transfer_tax_rate: str

        :param transfer_tax_amount:
            The value to assign to the transfer_tax_amount property of this DisbursementReportRecord.
        :type transfer_tax_amount: str

        :param lc_amount_for_disbursement_after_tax:
            The value to assign to the lc_amount_for_disbursement_after_tax property of this DisbursementReportRecord.
        :type lc_amount_for_disbursement_after_tax: str

        :param lc_partner_payment:
            The value to assign to the lc_partner_payment property of this DisbursementReportRecord.
        :type lc_partner_payment: str

        :param fx_rate_lc_to_usd:
            The value to assign to the fx_rate_lc_to_usd property of this DisbursementReportRecord.
        :type fx_rate_lc_to_usd: str

        :param disbursement_amount_usd:
            The value to assign to the disbursement_amount_usd property of this DisbursementReportRecord.
        :type disbursement_amount_usd: str

        :param partner_name:
            The value to assign to the partner_name property of this DisbursementReportRecord.
        :type partner_name: str

        :param partner_id:
            The value to assign to the partner_id property of this DisbursementReportRecord.
        :type partner_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DisbursementReportRecord.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DisbursementReportRecord.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DisbursementReportRecord.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'enterprise_quarter': 'str',
            'enterprise_period': 'str',
            'listing_name': 'str',
            'listing_id': 'str',
            'private_offer_id': 'str',
            'private_offer_name': 'str',
            'sku': 'str',
            'transaction_reference_id': 'str',
            'customer_id': 'str',
            'customer_name': 'str',
            'customer_domain': 'str',
            'end_user_customer_id': 'str',
            'end_user_customer_name': 'str',
            'country': 'str',
            'state': 'str',
            'city': 'str',
            'zip': 'str',
            'currency_code': 'str',
            'usage_quantity': 'str',
            'used_amount_lc': 'str',
            'lc_amount_for_disbursement_calculations': 'str',
            'lc_base_amount_for_tax_calculations': 'str',
            'withholding_tax_rate': 'str',
            'withholding_tax_amount': 'str',
            'transfer_tax_base_amount': 'str',
            'transfer_tax_rate': 'str',
            'transfer_tax_amount': 'str',
            'lc_amount_for_disbursement_after_tax': 'str',
            'lc_partner_payment': 'str',
            'fx_rate_lc_to_usd': 'str',
            'disbursement_amount_usd': 'str',
            'partner_name': 'str',
            'partner_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'enterprise_quarter': 'enterpriseQuarter',
            'enterprise_period': 'enterprisePeriod',
            'listing_name': 'listingName',
            'listing_id': 'listingId',
            'private_offer_id': 'privateOfferId',
            'private_offer_name': 'privateOfferName',
            'sku': 'sku',
            'transaction_reference_id': 'transactionReferenceId',
            'customer_id': 'customerId',
            'customer_name': 'customerName',
            'customer_domain': 'customerDomain',
            'end_user_customer_id': 'endUserCustomerId',
            'end_user_customer_name': 'endUserCustomerName',
            'country': 'country',
            'state': 'state',
            'city': 'city',
            'zip': 'zip',
            'currency_code': 'currencyCode',
            'usage_quantity': 'usageQuantity',
            'used_amount_lc': 'usedAmountLc',
            'lc_amount_for_disbursement_calculations': 'lcAmountForDisbursementCalculations',
            'lc_base_amount_for_tax_calculations': 'lcBaseAmountForTaxCalculations',
            'withholding_tax_rate': 'withholdingTaxRate',
            'withholding_tax_amount': 'withholdingTaxAmount',
            'transfer_tax_base_amount': 'transferTaxBaseAmount',
            'transfer_tax_rate': 'transferTaxRate',
            'transfer_tax_amount': 'transferTaxAmount',
            'lc_amount_for_disbursement_after_tax': 'lcAmountForDisbursementAfterTax',
            'lc_partner_payment': 'lcPartnerPayment',
            'fx_rate_lc_to_usd': 'fxRateLcToUsd',
            'disbursement_amount_usd': 'disbursementAmountUsd',
            'partner_name': 'partnerName',
            'partner_id': 'partnerId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._enterprise_quarter = None
        self._enterprise_period = None
        self._listing_name = None
        self._listing_id = None
        self._private_offer_id = None
        self._private_offer_name = None
        self._sku = None
        self._transaction_reference_id = None
        self._customer_id = None
        self._customer_name = None
        self._customer_domain = None
        self._end_user_customer_id = None
        self._end_user_customer_name = None
        self._country = None
        self._state = None
        self._city = None
        self._zip = None
        self._currency_code = None
        self._usage_quantity = None
        self._used_amount_lc = None
        self._lc_amount_for_disbursement_calculations = None
        self._lc_base_amount_for_tax_calculations = None
        self._withholding_tax_rate = None
        self._withholding_tax_amount = None
        self._transfer_tax_base_amount = None
        self._transfer_tax_rate = None
        self._transfer_tax_amount = None
        self._lc_amount_for_disbursement_after_tax = None
        self._lc_partner_payment = None
        self._fx_rate_lc_to_usd = None
        self._disbursement_amount_usd = None
        self._partner_name = None
        self._partner_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def enterprise_quarter(self):
        """
        Gets the enterprise_quarter of this DisbursementReportRecord.
        Enterprise Quarter


        :return: The enterprise_quarter of this DisbursementReportRecord.
        :rtype: str
        """
        return self._enterprise_quarter

    @enterprise_quarter.setter
    def enterprise_quarter(self, enterprise_quarter):
        """
        Sets the enterprise_quarter of this DisbursementReportRecord.
        Enterprise Quarter


        :param enterprise_quarter: The enterprise_quarter of this DisbursementReportRecord.
        :type: str
        """
        self._enterprise_quarter = enterprise_quarter

    @property
    def enterprise_period(self):
        """
        Gets the enterprise_period of this DisbursementReportRecord.
        Enterprise Period


        :return: The enterprise_period of this DisbursementReportRecord.
        :rtype: str
        """
        return self._enterprise_period

    @enterprise_period.setter
    def enterprise_period(self, enterprise_period):
        """
        Sets the enterprise_period of this DisbursementReportRecord.
        Enterprise Period


        :param enterprise_period: The enterprise_period of this DisbursementReportRecord.
        :type: str
        """
        self._enterprise_period = enterprise_period

    @property
    def listing_name(self):
        """
        Gets the listing_name of this DisbursementReportRecord.
        Listing Name


        :return: The listing_name of this DisbursementReportRecord.
        :rtype: str
        """
        return self._listing_name

    @listing_name.setter
    def listing_name(self, listing_name):
        """
        Sets the listing_name of this DisbursementReportRecord.
        Listing Name


        :param listing_name: The listing_name of this DisbursementReportRecord.
        :type: str
        """
        self._listing_name = listing_name

    @property
    def listing_id(self):
        """
        Gets the listing_id of this DisbursementReportRecord.
        Listing ID


        :return: The listing_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this DisbursementReportRecord.
        Listing ID


        :param listing_id: The listing_id of this DisbursementReportRecord.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def private_offer_id(self):
        """
        Gets the private_offer_id of this DisbursementReportRecord.
        Private Offer ID


        :return: The private_offer_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._private_offer_id

    @private_offer_id.setter
    def private_offer_id(self, private_offer_id):
        """
        Sets the private_offer_id of this DisbursementReportRecord.
        Private Offer ID


        :param private_offer_id: The private_offer_id of this DisbursementReportRecord.
        :type: str
        """
        self._private_offer_id = private_offer_id

    @property
    def private_offer_name(self):
        """
        Gets the private_offer_name of this DisbursementReportRecord.
        Private Offer Name


        :return: The private_offer_name of this DisbursementReportRecord.
        :rtype: str
        """
        return self._private_offer_name

    @private_offer_name.setter
    def private_offer_name(self, private_offer_name):
        """
        Sets the private_offer_name of this DisbursementReportRecord.
        Private Offer Name


        :param private_offer_name: The private_offer_name of this DisbursementReportRecord.
        :type: str
        """
        self._private_offer_name = private_offer_name

    @property
    def sku(self):
        """
        Gets the sku of this DisbursementReportRecord.
        SKU


        :return: The sku of this DisbursementReportRecord.
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """
        Sets the sku of this DisbursementReportRecord.
        SKU


        :param sku: The sku of this DisbursementReportRecord.
        :type: str
        """
        self._sku = sku

    @property
    def transaction_reference_id(self):
        """
        Gets the transaction_reference_id of this DisbursementReportRecord.
        Transaction Reference ID


        :return: The transaction_reference_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._transaction_reference_id

    @transaction_reference_id.setter
    def transaction_reference_id(self, transaction_reference_id):
        """
        Sets the transaction_reference_id of this DisbursementReportRecord.
        Transaction Reference ID


        :param transaction_reference_id: The transaction_reference_id of this DisbursementReportRecord.
        :type: str
        """
        self._transaction_reference_id = transaction_reference_id

    @property
    def customer_id(self):
        """
        Gets the customer_id of this DisbursementReportRecord.
        Customer ID


        :return: The customer_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """
        Sets the customer_id of this DisbursementReportRecord.
        Customer ID


        :param customer_id: The customer_id of this DisbursementReportRecord.
        :type: str
        """
        self._customer_id = customer_id

    @property
    def customer_name(self):
        """
        Gets the customer_name of this DisbursementReportRecord.
        Customer Name


        :return: The customer_name of this DisbursementReportRecord.
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """
        Sets the customer_name of this DisbursementReportRecord.
        Customer Name


        :param customer_name: The customer_name of this DisbursementReportRecord.
        :type: str
        """
        self._customer_name = customer_name

    @property
    def customer_domain(self):
        """
        Gets the customer_domain of this DisbursementReportRecord.
        Customer Domain


        :return: The customer_domain of this DisbursementReportRecord.
        :rtype: str
        """
        return self._customer_domain

    @customer_domain.setter
    def customer_domain(self, customer_domain):
        """
        Sets the customer_domain of this DisbursementReportRecord.
        Customer Domain


        :param customer_domain: The customer_domain of this DisbursementReportRecord.
        :type: str
        """
        self._customer_domain = customer_domain

    @property
    def end_user_customer_id(self):
        """
        Gets the end_user_customer_id of this DisbursementReportRecord.
        End User Customer ID


        :return: The end_user_customer_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._end_user_customer_id

    @end_user_customer_id.setter
    def end_user_customer_id(self, end_user_customer_id):
        """
        Sets the end_user_customer_id of this DisbursementReportRecord.
        End User Customer ID


        :param end_user_customer_id: The end_user_customer_id of this DisbursementReportRecord.
        :type: str
        """
        self._end_user_customer_id = end_user_customer_id

    @property
    def end_user_customer_name(self):
        """
        Gets the end_user_customer_name of this DisbursementReportRecord.
        EEnd User Customer Name


        :return: The end_user_customer_name of this DisbursementReportRecord.
        :rtype: str
        """
        return self._end_user_customer_name

    @end_user_customer_name.setter
    def end_user_customer_name(self, end_user_customer_name):
        """
        Sets the end_user_customer_name of this DisbursementReportRecord.
        EEnd User Customer Name


        :param end_user_customer_name: The end_user_customer_name of this DisbursementReportRecord.
        :type: str
        """
        self._end_user_customer_name = end_user_customer_name

    @property
    def country(self):
        """
        Gets the country of this DisbursementReportRecord.
        Country


        :return: The country of this DisbursementReportRecord.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this DisbursementReportRecord.
        Country


        :param country: The country of this DisbursementReportRecord.
        :type: str
        """
        self._country = country

    @property
    def state(self):
        """
        Gets the state of this DisbursementReportRecord.
        State


        :return: The state of this DisbursementReportRecord.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this DisbursementReportRecord.
        State


        :param state: The state of this DisbursementReportRecord.
        :type: str
        """
        self._state = state

    @property
    def city(self):
        """
        Gets the city of this DisbursementReportRecord.
        City


        :return: The city of this DisbursementReportRecord.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this DisbursementReportRecord.
        City


        :param city: The city of this DisbursementReportRecord.
        :type: str
        """
        self._city = city

    @property
    def zip(self):
        """
        Gets the zip of this DisbursementReportRecord.
        Zip


        :return: The zip of this DisbursementReportRecord.
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """
        Sets the zip of this DisbursementReportRecord.
        Zip


        :param zip: The zip of this DisbursementReportRecord.
        :type: str
        """
        self._zip = zip

    @property
    def currency_code(self):
        """
        Gets the currency_code of this DisbursementReportRecord.
        Currency Code


        :return: The currency_code of this DisbursementReportRecord.
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """
        Sets the currency_code of this DisbursementReportRecord.
        Currency Code


        :param currency_code: The currency_code of this DisbursementReportRecord.
        :type: str
        """
        self._currency_code = currency_code

    @property
    def usage_quantity(self):
        """
        Gets the usage_quantity of this DisbursementReportRecord.
        Usage Quantity


        :return: The usage_quantity of this DisbursementReportRecord.
        :rtype: str
        """
        return self._usage_quantity

    @usage_quantity.setter
    def usage_quantity(self, usage_quantity):
        """
        Sets the usage_quantity of this DisbursementReportRecord.
        Usage Quantity


        :param usage_quantity: The usage_quantity of this DisbursementReportRecord.
        :type: str
        """
        self._usage_quantity = usage_quantity

    @property
    def used_amount_lc(self):
        """
        Gets the used_amount_lc of this DisbursementReportRecord.
        Used Amount (LC)


        :return: The used_amount_lc of this DisbursementReportRecord.
        :rtype: str
        """
        return self._used_amount_lc

    @used_amount_lc.setter
    def used_amount_lc(self, used_amount_lc):
        """
        Sets the used_amount_lc of this DisbursementReportRecord.
        Used Amount (LC)


        :param used_amount_lc: The used_amount_lc of this DisbursementReportRecord.
        :type: str
        """
        self._used_amount_lc = used_amount_lc

    @property
    def lc_amount_for_disbursement_calculations(self):
        """
        Gets the lc_amount_for_disbursement_calculations of this DisbursementReportRecord.
        LC Amount for Disbursement Calculations


        :return: The lc_amount_for_disbursement_calculations of this DisbursementReportRecord.
        :rtype: str
        """
        return self._lc_amount_for_disbursement_calculations

    @lc_amount_for_disbursement_calculations.setter
    def lc_amount_for_disbursement_calculations(self, lc_amount_for_disbursement_calculations):
        """
        Sets the lc_amount_for_disbursement_calculations of this DisbursementReportRecord.
        LC Amount for Disbursement Calculations


        :param lc_amount_for_disbursement_calculations: The lc_amount_for_disbursement_calculations of this DisbursementReportRecord.
        :type: str
        """
        self._lc_amount_for_disbursement_calculations = lc_amount_for_disbursement_calculations

    @property
    def lc_base_amount_for_tax_calculations(self):
        """
        Gets the lc_base_amount_for_tax_calculations of this DisbursementReportRecord.
        LC Base Amount for Tax Calculations


        :return: The lc_base_amount_for_tax_calculations of this DisbursementReportRecord.
        :rtype: str
        """
        return self._lc_base_amount_for_tax_calculations

    @lc_base_amount_for_tax_calculations.setter
    def lc_base_amount_for_tax_calculations(self, lc_base_amount_for_tax_calculations):
        """
        Sets the lc_base_amount_for_tax_calculations of this DisbursementReportRecord.
        LC Base Amount for Tax Calculations


        :param lc_base_amount_for_tax_calculations: The lc_base_amount_for_tax_calculations of this DisbursementReportRecord.
        :type: str
        """
        self._lc_base_amount_for_tax_calculations = lc_base_amount_for_tax_calculations

    @property
    def withholding_tax_rate(self):
        """
        Gets the withholding_tax_rate of this DisbursementReportRecord.
        Withholding Tax Rate


        :return: The withholding_tax_rate of this DisbursementReportRecord.
        :rtype: str
        """
        return self._withholding_tax_rate

    @withholding_tax_rate.setter
    def withholding_tax_rate(self, withholding_tax_rate):
        """
        Sets the withholding_tax_rate of this DisbursementReportRecord.
        Withholding Tax Rate


        :param withholding_tax_rate: The withholding_tax_rate of this DisbursementReportRecord.
        :type: str
        """
        self._withholding_tax_rate = withholding_tax_rate

    @property
    def withholding_tax_amount(self):
        """
        Gets the withholding_tax_amount of this DisbursementReportRecord.
        Withholding Tax Amount


        :return: The withholding_tax_amount of this DisbursementReportRecord.
        :rtype: str
        """
        return self._withholding_tax_amount

    @withholding_tax_amount.setter
    def withholding_tax_amount(self, withholding_tax_amount):
        """
        Sets the withholding_tax_amount of this DisbursementReportRecord.
        Withholding Tax Amount


        :param withholding_tax_amount: The withholding_tax_amount of this DisbursementReportRecord.
        :type: str
        """
        self._withholding_tax_amount = withholding_tax_amount

    @property
    def transfer_tax_base_amount(self):
        """
        Gets the transfer_tax_base_amount of this DisbursementReportRecord.
        Transfer Tax Base Amount


        :return: The transfer_tax_base_amount of this DisbursementReportRecord.
        :rtype: str
        """
        return self._transfer_tax_base_amount

    @transfer_tax_base_amount.setter
    def transfer_tax_base_amount(self, transfer_tax_base_amount):
        """
        Sets the transfer_tax_base_amount of this DisbursementReportRecord.
        Transfer Tax Base Amount


        :param transfer_tax_base_amount: The transfer_tax_base_amount of this DisbursementReportRecord.
        :type: str
        """
        self._transfer_tax_base_amount = transfer_tax_base_amount

    @property
    def transfer_tax_rate(self):
        """
        Gets the transfer_tax_rate of this DisbursementReportRecord.
        Transfer Tax Rate


        :return: The transfer_tax_rate of this DisbursementReportRecord.
        :rtype: str
        """
        return self._transfer_tax_rate

    @transfer_tax_rate.setter
    def transfer_tax_rate(self, transfer_tax_rate):
        """
        Sets the transfer_tax_rate of this DisbursementReportRecord.
        Transfer Tax Rate


        :param transfer_tax_rate: The transfer_tax_rate of this DisbursementReportRecord.
        :type: str
        """
        self._transfer_tax_rate = transfer_tax_rate

    @property
    def transfer_tax_amount(self):
        """
        Gets the transfer_tax_amount of this DisbursementReportRecord.
        Transfer Tax Amount


        :return: The transfer_tax_amount of this DisbursementReportRecord.
        :rtype: str
        """
        return self._transfer_tax_amount

    @transfer_tax_amount.setter
    def transfer_tax_amount(self, transfer_tax_amount):
        """
        Sets the transfer_tax_amount of this DisbursementReportRecord.
        Transfer Tax Amount


        :param transfer_tax_amount: The transfer_tax_amount of this DisbursementReportRecord.
        :type: str
        """
        self._transfer_tax_amount = transfer_tax_amount

    @property
    def lc_amount_for_disbursement_after_tax(self):
        """
        Gets the lc_amount_for_disbursement_after_tax of this DisbursementReportRecord.
        LC Amount for Disbursement after Tax


        :return: The lc_amount_for_disbursement_after_tax of this DisbursementReportRecord.
        :rtype: str
        """
        return self._lc_amount_for_disbursement_after_tax

    @lc_amount_for_disbursement_after_tax.setter
    def lc_amount_for_disbursement_after_tax(self, lc_amount_for_disbursement_after_tax):
        """
        Sets the lc_amount_for_disbursement_after_tax of this DisbursementReportRecord.
        LC Amount for Disbursement after Tax


        :param lc_amount_for_disbursement_after_tax: The lc_amount_for_disbursement_after_tax of this DisbursementReportRecord.
        :type: str
        """
        self._lc_amount_for_disbursement_after_tax = lc_amount_for_disbursement_after_tax

    @property
    def lc_partner_payment(self):
        """
        Gets the lc_partner_payment of this DisbursementReportRecord.
        LC Partner Payment


        :return: The lc_partner_payment of this DisbursementReportRecord.
        :rtype: str
        """
        return self._lc_partner_payment

    @lc_partner_payment.setter
    def lc_partner_payment(self, lc_partner_payment):
        """
        Sets the lc_partner_payment of this DisbursementReportRecord.
        LC Partner Payment


        :param lc_partner_payment: The lc_partner_payment of this DisbursementReportRecord.
        :type: str
        """
        self._lc_partner_payment = lc_partner_payment

    @property
    def fx_rate_lc_to_usd(self):
        """
        Gets the fx_rate_lc_to_usd of this DisbursementReportRecord.
        FX Rate (LC to USD)


        :return: The fx_rate_lc_to_usd of this DisbursementReportRecord.
        :rtype: str
        """
        return self._fx_rate_lc_to_usd

    @fx_rate_lc_to_usd.setter
    def fx_rate_lc_to_usd(self, fx_rate_lc_to_usd):
        """
        Sets the fx_rate_lc_to_usd of this DisbursementReportRecord.
        FX Rate (LC to USD)


        :param fx_rate_lc_to_usd: The fx_rate_lc_to_usd of this DisbursementReportRecord.
        :type: str
        """
        self._fx_rate_lc_to_usd = fx_rate_lc_to_usd

    @property
    def disbursement_amount_usd(self):
        """
        Gets the disbursement_amount_usd of this DisbursementReportRecord.
        Disbursement Amount (USD)


        :return: The disbursement_amount_usd of this DisbursementReportRecord.
        :rtype: str
        """
        return self._disbursement_amount_usd

    @disbursement_amount_usd.setter
    def disbursement_amount_usd(self, disbursement_amount_usd):
        """
        Sets the disbursement_amount_usd of this DisbursementReportRecord.
        Disbursement Amount (USD)


        :param disbursement_amount_usd: The disbursement_amount_usd of this DisbursementReportRecord.
        :type: str
        """
        self._disbursement_amount_usd = disbursement_amount_usd

    @property
    def partner_name(self):
        """
        Gets the partner_name of this DisbursementReportRecord.
        Partner Name


        :return: The partner_name of this DisbursementReportRecord.
        :rtype: str
        """
        return self._partner_name

    @partner_name.setter
    def partner_name(self, partner_name):
        """
        Sets the partner_name of this DisbursementReportRecord.
        Partner Name


        :param partner_name: The partner_name of this DisbursementReportRecord.
        :type: str
        """
        self._partner_name = partner_name

    @property
    def partner_id(self):
        """
        Gets the partner_id of this DisbursementReportRecord.
        Partner OCID


        :return: The partner_id of this DisbursementReportRecord.
        :rtype: str
        """
        return self._partner_id

    @partner_id.setter
    def partner_id(self, partner_id):
        """
        Sets the partner_id of this DisbursementReportRecord.
        Partner OCID


        :param partner_id: The partner_id of this DisbursementReportRecord.
        :type: str
        """
        self._partner_id = partner_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DisbursementReportRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DisbursementReportRecord.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DisbursementReportRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DisbursementReportRecord.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DisbursementReportRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DisbursementReportRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DisbursementReportRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DisbursementReportRecord.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DisbursementReportRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DisbursementReportRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DisbursementReportRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DisbursementReportRecord.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
