# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Lead(object):
    """
    Details of Lead
    """

    #: A constant which can be used with the lifecycle_state property of a Lead.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Lead.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new Lead object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Lead.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this Lead.
        :type listing_id: str

        :param listing_name:
            The value to assign to the listing_name property of this Lead.
        :type listing_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Lead.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Lead.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this Lead.
        :type time_created: datetime

        :param additional_info:
            The value to assign to the additional_info property of this Lead.
        :type additional_info: oci.marketplace_publisher.models.AdditionalInfo

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'listing_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'additional_info': 'AdditionalInfo'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'listing_name': 'listingName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'additional_info': 'additionalInfo'
        }
        self._id = None
        self._listing_id = None
        self._listing_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._additional_info = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Lead.
        Unique OCID identifier for the lead.


        :return: The id of this Lead.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Lead.
        Unique OCID identifier for the lead.


        :param id: The id of this Lead.
        :type: str
        """
        self._id = id

    @property
    def listing_id(self):
        """
        **[Required]** Gets the listing_id of this Lead.
        The OCID for the listing.


        :return: The listing_id of this Lead.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this Lead.
        The OCID for the listing.


        :param listing_id: The listing_id of this Lead.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_name(self):
        """
        **[Required]** Gets the listing_name of this Lead.
        The Name for the listing.


        :return: The listing_name of this Lead.
        :rtype: str
        """
        return self._listing_name

    @listing_name.setter
    def listing_name(self, listing_name):
        """
        Sets the listing_name of this Lead.
        The Name for the listing.


        :param listing_name: The listing_name of this Lead.
        :type: str
        """
        self._listing_name = listing_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Lead.
        The OCID for the compartment.


        :return: The compartment_id of this Lead.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Lead.
        The OCID for the compartment.


        :param compartment_id: The compartment_id of this Lead.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Lead.
        The state for the listing.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Lead.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Lead.
        The state for the listing.


        :param lifecycle_state: The lifecycle_state of this Lead.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this Lead.
        The date and time the listing was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Lead.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Lead.
        The date and time the listing was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Lead.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def additional_info(self):
        """
        Gets the additional_info of this Lead.

        :return: The additional_info of this Lead.
        :rtype: oci.marketplace_publisher.models.AdditionalInfo
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """
        Sets the additional_info of this Lead.

        :param additional_info: The additional_info of this Lead.
        :type: oci.marketplace_publisher.models.AdditionalInfo
        """
        self._additional_info = additional_info

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
