# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .pricing_plan import PricingPlan
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SaaSPricingPlan(PricingPlan):
    """
    SaaS pricing plan.
    """

    #: A constant which can be used with the billing_frequency property of a SaaSPricingPlan.
    #: This constant has a value of "MONTHLY"
    BILLING_FREQUENCY_MONTHLY = "MONTHLY"

    #: A constant which can be used with the billing_frequency property of a SaaSPricingPlan.
    #: This constant has a value of "QUARTERLY"
    BILLING_FREQUENCY_QUARTERLY = "QUARTERLY"

    #: A constant which can be used with the billing_frequency property of a SaaSPricingPlan.
    #: This constant has a value of "YEARLY"
    BILLING_FREQUENCY_YEARLY = "YEARLY"

    def __init__(self, **kwargs):
        """
        Initializes a new SaaSPricingPlan object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.SaaSPricingPlan.plan_type` attribute
        of this class is ``FIXED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param plan_type:
            The value to assign to the plan_type property of this SaaSPricingPlan.
            Allowed values for this property are: "METERED", "FIXED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type plan_type: str

        :param rates:
            The value to assign to the rates property of this SaaSPricingPlan.
        :type rates: list[oci.marketplace_publisher.models.PricingRate]

        :param name:
            The value to assign to the name property of this SaaSPricingPlan.
        :type name: str

        :param plan_description:
            The value to assign to the plan_description property of this SaaSPricingPlan.
        :type plan_description: str

        :param billing_frequency:
            The value to assign to the billing_frequency property of this SaaSPricingPlan.
            Allowed values for this property are: "MONTHLY", "QUARTERLY", "YEARLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type billing_frequency: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this SaaSPricingPlan.
        :type extended_metadata: dict(str, str)

        """
        self.swagger_types = {
            'plan_type': 'str',
            'rates': 'list[PricingRate]',
            'name': 'str',
            'plan_description': 'str',
            'billing_frequency': 'str',
            'extended_metadata': 'dict(str, str)'
        }
        self.attribute_map = {
            'plan_type': 'planType',
            'rates': 'rates',
            'name': 'name',
            'plan_description': 'planDescription',
            'billing_frequency': 'billingFrequency',
            'extended_metadata': 'extendedMetadata'
        }
        self._plan_type = None
        self._rates = None
        self._name = None
        self._plan_description = None
        self._billing_frequency = None
        self._extended_metadata = None
        self._plan_type = 'FIXED'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SaaSPricingPlan.
        The plan name.


        :return: The name of this SaaSPricingPlan.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SaaSPricingPlan.
        The plan name.


        :param name: The name of this SaaSPricingPlan.
        :type: str
        """
        self._name = name

    @property
    def plan_description(self):
        """
        **[Required]** Gets the plan_description of this SaaSPricingPlan.
        The plan description.


        :return: The plan_description of this SaaSPricingPlan.
        :rtype: str
        """
        return self._plan_description

    @plan_description.setter
    def plan_description(self, plan_description):
        """
        Sets the plan_description of this SaaSPricingPlan.
        The plan description.


        :param plan_description: The plan_description of this SaaSPricingPlan.
        :type: str
        """
        self._plan_description = plan_description

    @property
    def billing_frequency(self):
        """
        **[Required]** Gets the billing_frequency of this SaaSPricingPlan.
        The plan billing frequency.

        Allowed values for this property are: "MONTHLY", "QUARTERLY", "YEARLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The billing_frequency of this SaaSPricingPlan.
        :rtype: str
        """
        return self._billing_frequency

    @billing_frequency.setter
    def billing_frequency(self, billing_frequency):
        """
        Sets the billing_frequency of this SaaSPricingPlan.
        The plan billing frequency.


        :param billing_frequency: The billing_frequency of this SaaSPricingPlan.
        :type: str
        """
        allowed_values = ["MONTHLY", "QUARTERLY", "YEARLY"]
        if not value_allowed_none_or_none_sentinel(billing_frequency, allowed_values):
            billing_frequency = 'UNKNOWN_ENUM_VALUE'
        self._billing_frequency = billing_frequency

    @property
    def extended_metadata(self):
        """
        Gets the extended_metadata of this SaaSPricingPlan.
        Additional metadata key/value pairs for the saas pricing.


        :return: The extended_metadata of this SaaSPricingPlan.
        :rtype: dict(str, str)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this SaaSPricingPlan.
        Additional metadata key/value pairs for the saas pricing.


        :param extended_metadata: The extended_metadata of this SaaSPricingPlan.
        :type: dict(str, str)
        """
        self._extended_metadata = extended_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
