# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TermVersionAttachment(object):
    """
    An attachment uploaded by the Publisher for the term.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TermVersionAttachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_url:
            The value to assign to the content_url property of this TermVersionAttachment.
        :type content_url: str

        :param mime_type:
            The value to assign to the mime_type property of this TermVersionAttachment.
        :type mime_type: str

        """
        self.swagger_types = {
            'content_url': 'str',
            'mime_type': 'str'
        }
        self.attribute_map = {
            'content_url': 'contentUrl',
            'mime_type': 'mimeType'
        }
        self._content_url = None
        self._mime_type = None

    @property
    def content_url(self):
        """
        **[Required]** Gets the content_url of this TermVersionAttachment.
        The content URL of the uploaded data.


        :return: The content_url of this TermVersionAttachment.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this TermVersionAttachment.
        The content URL of the uploaded data.


        :param content_url: The content_url of this TermVersionAttachment.
        :type: str
        """
        self._content_url = content_url

    @property
    def mime_type(self):
        """
        **[Required]** Gets the mime_type of this TermVersionAttachment.
        The MIME type of the uploaded data.


        :return: The mime_type of this TermVersionAttachment.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this TermVersionAttachment.
        The MIME type of the uploaded data.


        :param mime_type: The mime_type of this TermVersionAttachment.
        :type: str
        """
        self._mime_type = mime_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
