# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalLocation(object):
    """
    External location for CSP Region, CSP-Physical-AZ
    """

    #: A constant which can be used with the service_name property of a ExternalLocation.
    #: This constant has a value of "ORACLEDBATAZURE"
    SERVICE_NAME_ORACLEDBATAZURE = "ORACLEDBATAZURE"

    #: A constant which can be used with the service_name property of a ExternalLocation.
    #: This constant has a value of "ORACLEDBATGOOGLE"
    SERVICE_NAME_ORACLEDBATGOOGLE = "ORACLEDBATGOOGLE"

    #: A constant which can be used with the service_name property of a ExternalLocation.
    #: This constant has a value of "ORACLEDBATAWS"
    SERVICE_NAME_ORACLEDBATAWS = "ORACLEDBATAWS"

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalLocation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param csp_region:
            The value to assign to the csp_region property of this ExternalLocation.
        :type csp_region: str

        :param csp_region_display_name:
            The value to assign to the csp_region_display_name property of this ExternalLocation.
        :type csp_region_display_name: str

        :param csp_physical_az:
            The value to assign to the csp_physical_az property of this ExternalLocation.
        :type csp_physical_az: str

        :param csp_physical_az_display_name:
            The value to assign to the csp_physical_az_display_name property of this ExternalLocation.
        :type csp_physical_az_display_name: str

        :param service_name:
            The value to assign to the service_name property of this ExternalLocation.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_name: str

        """
        self.swagger_types = {
            'csp_region': 'str',
            'csp_region_display_name': 'str',
            'csp_physical_az': 'str',
            'csp_physical_az_display_name': 'str',
            'service_name': 'str'
        }
        self.attribute_map = {
            'csp_region': 'cspRegion',
            'csp_region_display_name': 'cspRegionDisplayName',
            'csp_physical_az': 'cspPhysicalAz',
            'csp_physical_az_display_name': 'cspPhysicalAzDisplayName',
            'service_name': 'serviceName'
        }
        self._csp_region = None
        self._csp_region_display_name = None
        self._csp_physical_az = None
        self._csp_physical_az_display_name = None
        self._service_name = None

    @property
    def csp_region(self):
        """
        **[Required]** Gets the csp_region of this ExternalLocation.
        CSP region corresponding to the given OCI region


        :return: The csp_region of this ExternalLocation.
        :rtype: str
        """
        return self._csp_region

    @csp_region.setter
    def csp_region(self, csp_region):
        """
        Sets the csp_region of this ExternalLocation.
        CSP region corresponding to the given OCI region


        :param csp_region: The csp_region of this ExternalLocation.
        :type: str
        """
        self._csp_region = csp_region

    @property
    def csp_region_display_name(self):
        """
        **[Required]** Gets the csp_region_display_name of this ExternalLocation.
        CSP region display Name corresponding to the given OCI region


        :return: The csp_region_display_name of this ExternalLocation.
        :rtype: str
        """
        return self._csp_region_display_name

    @csp_region_display_name.setter
    def csp_region_display_name(self, csp_region_display_name):
        """
        Sets the csp_region_display_name of this ExternalLocation.
        CSP region display Name corresponding to the given OCI region


        :param csp_region_display_name: The csp_region_display_name of this ExternalLocation.
        :type: str
        """
        self._csp_region_display_name = csp_region_display_name

    @property
    def csp_physical_az(self):
        """
        **[Required]** Gets the csp_physical_az of this ExternalLocation.
        A mapping of OCI site group name to CSP physical availability zone name


        :return: The csp_physical_az of this ExternalLocation.
        :rtype: str
        """
        return self._csp_physical_az

    @csp_physical_az.setter
    def csp_physical_az(self, csp_physical_az):
        """
        Sets the csp_physical_az of this ExternalLocation.
        A mapping of OCI site group name to CSP physical availability zone name


        :param csp_physical_az: The csp_physical_az of this ExternalLocation.
        :type: str
        """
        self._csp_physical_az = csp_physical_az

    @property
    def csp_physical_az_display_name(self):
        """
        **[Required]** Gets the csp_physical_az_display_name of this ExternalLocation.
        User friendly display name for cspPhysicalAZ


        :return: The csp_physical_az_display_name of this ExternalLocation.
        :rtype: str
        """
        return self._csp_physical_az_display_name

    @csp_physical_az_display_name.setter
    def csp_physical_az_display_name(self, csp_physical_az_display_name):
        """
        Sets the csp_physical_az_display_name of this ExternalLocation.
        User friendly display name for cspPhysicalAZ


        :param csp_physical_az_display_name: The csp_physical_az_display_name of this ExternalLocation.
        :type: str
        """
        self._csp_physical_az_display_name = csp_physical_az_display_name

    @property
    def service_name(self):
        """
        Gets the service_name of this ExternalLocation.
        The serviceName that externalLocation map object belongs to

        Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_name of this ExternalLocation.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this ExternalLocation.
        The serviceName that externalLocation map object belongs to


        :param service_name: The service_name of this ExternalLocation.
        :type: str
        """
        allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if not value_allowed_none_or_none_sentinel(service_name, allowed_values):
            service_name = 'UNKNOWN_ENUM_VALUE'
        self._service_name = service_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
