# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseConsoleDetails(object):
    """
    Database console configuration details.
    """

    #: A constant which can be used with the status property of a DatabaseConsoleDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a DatabaseConsoleDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseConsoleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this DatabaseConsoleDetails.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param port:
            The value to assign to the port property of this DatabaseConsoleDetails.
        :type port: int

        """
        self.swagger_types = {
            'status': 'str',
            'port': 'int'
        }
        self.attribute_map = {
            'status': 'status',
            'port': 'port'
        }
        self._status = None
        self._port = None

    @property
    def status(self):
        """
        **[Required]** Gets the status of this DatabaseConsoleDetails.
        Whether the database console is enabled on the DB System.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this DatabaseConsoleDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this DatabaseConsoleDetails.
        Whether the database console is enabled on the DB System.


        :param status: The status of this DatabaseConsoleDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def port(self):
        """
        Gets the port of this DatabaseConsoleDetails.
        The port on which the database console can be accessed. Supported port numbers are 443 and from 1024 to 65535.


        :return: The port of this DatabaseConsoleDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DatabaseConsoleDetails.
        The port on which the database console can be accessed. Supported port numbers are 443 and from 1024 to 65535.


        :param port: The port of this DatabaseConsoleDetails.
        :type: int
        """
        self._port = port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
