# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PreparedBackupDetails(object):
    """
    Prepared backup details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PreparedBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param prepared_backup_restore_reduction_in_minutes:
            The value to assign to the prepared_backup_restore_reduction_in_minutes property of this PreparedBackupDetails.
        :type prepared_backup_restore_reduction_in_minutes: int

        :param time_prepared:
            The value to assign to the time_prepared property of this PreparedBackupDetails.
        :type time_prepared: datetime

        """
        self.swagger_types = {
            'prepared_backup_restore_reduction_in_minutes': 'int',
            'time_prepared': 'datetime'
        }
        self.attribute_map = {
            'prepared_backup_restore_reduction_in_minutes': 'preparedBackupRestoreReductionInMinutes',
            'time_prepared': 'timePrepared'
        }
        self._prepared_backup_restore_reduction_in_minutes = None
        self._time_prepared = None

    @property
    def prepared_backup_restore_reduction_in_minutes(self):
        """
        Gets the prepared_backup_restore_reduction_in_minutes of this PreparedBackupDetails.
        The estimated time saving when this prepared backup is restored.


        :return: The prepared_backup_restore_reduction_in_minutes of this PreparedBackupDetails.
        :rtype: int
        """
        return self._prepared_backup_restore_reduction_in_minutes

    @prepared_backup_restore_reduction_in_minutes.setter
    def prepared_backup_restore_reduction_in_minutes(self, prepared_backup_restore_reduction_in_minutes):
        """
        Sets the prepared_backup_restore_reduction_in_minutes of this PreparedBackupDetails.
        The estimated time saving when this prepared backup is restored.


        :param prepared_backup_restore_reduction_in_minutes: The prepared_backup_restore_reduction_in_minutes of this PreparedBackupDetails.
        :type: int
        """
        self._prepared_backup_restore_reduction_in_minutes = prepared_backup_restore_reduction_in_minutes

    @property
    def time_prepared(self):
        """
        Gets the time_prepared of this PreparedBackupDetails.
        The date and time the backup was prepared.


        :return: The time_prepared of this PreparedBackupDetails.
        :rtype: datetime
        """
        return self._time_prepared

    @time_prepared.setter
    def time_prepared(self, time_prepared):
        """
        Sets the time_prepared of this PreparedBackupDetails.
        The date and time the backup was prepared.


        :param time_prepared: The time_prepared of this PreparedBackupDetails.
        :type: datetime
        """
        self._time_prepared = time_prepared

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
