# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateUrlListDetails(object):
    """
    The Request for creating the URL List
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateUrlListDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateUrlListDetails.
        :type name: str

        :param urls:
            The value to assign to the urls property of this CreateUrlListDetails.
        :type urls: list[oci.network_firewall.models.UrlPattern]

        """
        self.swagger_types = {
            'name': 'str',
            'urls': 'list[UrlPattern]'
        }
        self.attribute_map = {
            'name': 'name',
            'urls': 'urls'
        }
        self._name = None
        self._urls = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateUrlListDetails.
        Unique name to identify the group of urls to be used in the policy rules.


        :return: The name of this CreateUrlListDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateUrlListDetails.
        Unique name to identify the group of urls to be used in the policy rules.


        :param name: The name of this CreateUrlListDetails.
        :type: str
        """
        self._name = name

    @property
    def urls(self):
        """
        **[Required]** Gets the urls of this CreateUrlListDetails.
        List of urls.


        :return: The urls of this CreateUrlListDetails.
        :rtype: list[oci.network_firewall.models.UrlPattern]
        """
        return self._urls

    @urls.setter
    def urls(self, urls):
        """
        Sets the urls of this CreateUrlListDetails.
        List of urls.


        :param urls: The urls of this CreateUrlListDetails.
        :type: list[oci.network_firewall.models.UrlPattern]
        """
        self._urls = urls

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
