# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501

from .update_nat_rule_details import UpdateNatRuleDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateNatV4RuleDetails(UpdateNatRuleDetails):
    """
    Request for updating NATV4 type Nat Rule used in the firewall policy.
    """

    #: A constant which can be used with the action property of a UpdateNatV4RuleDetails.
    #: This constant has a value of "DIPP_SRC_NAT"
    ACTION_DIPP_SRC_NAT = "DIPP_SRC_NAT"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateNatV4RuleDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.network_firewall.models.UpdateNatV4RuleDetails.type` attribute
        of this class is ``NATV4`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateNatV4RuleDetails.
            Allowed values for this property are: "NATV4"
        :type type: str

        :param description:
            The value to assign to the description property of this UpdateNatV4RuleDetails.
        :type description: str

        :param position:
            The value to assign to the position property of this UpdateNatV4RuleDetails.
        :type position: oci.network_firewall.models.RulePosition

        :param condition:
            The value to assign to the condition property of this UpdateNatV4RuleDetails.
        :type condition: oci.network_firewall.models.NatRuleMatchCriteria

        :param action:
            The value to assign to the action property of this UpdateNatV4RuleDetails.
            Allowed values for this property are: "DIPP_SRC_NAT"
        :type action: str

        """
        self.swagger_types = {
            'type': 'str',
            'description': 'str',
            'position': 'RulePosition',
            'condition': 'NatRuleMatchCriteria',
            'action': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'description': 'description',
            'position': 'position',
            'condition': 'condition',
            'action': 'action'
        }
        self._type = None
        self._description = None
        self._position = None
        self._condition = None
        self._action = None
        self._type = 'NATV4'

    @property
    def condition(self):
        """
        **[Required]** Gets the condition of this UpdateNatV4RuleDetails.

        :return: The condition of this UpdateNatV4RuleDetails.
        :rtype: oci.network_firewall.models.NatRuleMatchCriteria
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """
        Sets the condition of this UpdateNatV4RuleDetails.

        :param condition: The condition of this UpdateNatV4RuleDetails.
        :type: oci.network_firewall.models.NatRuleMatchCriteria
        """
        self._condition = condition

    @property
    def action(self):
        """
        **[Required]** Gets the action of this UpdateNatV4RuleDetails.
        action:

        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.

        Allowed values for this property are: "DIPP_SRC_NAT"


        :return: The action of this UpdateNatV4RuleDetails.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this UpdateNatV4RuleDetails.
        action:

        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.


        :param action: The action of this UpdateNatV4RuleDetails.
        :type: str
        """
        allowed_values = ["DIPP_SRC_NAT"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
