# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BlockVolumeAttachment(object):
    """
    The details about the attachment of block volume.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BlockVolumeAttachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param esxi_host_id:
            The value to assign to the esxi_host_id property of this BlockVolumeAttachment.
        :type esxi_host_id: str

        :param ip_address:
            The value to assign to the ip_address property of this BlockVolumeAttachment.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this BlockVolumeAttachment.
        :type port: int

        """
        self.swagger_types = {
            'esxi_host_id': 'str',
            'ip_address': 'str',
            'port': 'int'
        }
        self.attribute_map = {
            'esxi_host_id': 'esxiHostId',
            'ip_address': 'ipAddress',
            'port': 'port'
        }
        self._esxi_host_id = None
        self._ip_address = None
        self._port = None

    @property
    def esxi_host_id(self):
        """
        **[Required]** Gets the esxi_host_id of this BlockVolumeAttachment.
        The `OCIDs`__ of the ESXi host that block volume is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The esxi_host_id of this BlockVolumeAttachment.
        :rtype: str
        """
        return self._esxi_host_id

    @esxi_host_id.setter
    def esxi_host_id(self, esxi_host_id):
        """
        Sets the esxi_host_id of this BlockVolumeAttachment.
        The `OCIDs`__ of the ESXi host that block volume is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param esxi_host_id: The esxi_host_id of this BlockVolumeAttachment.
        :type: str
        """
        self._esxi_host_id = esxi_host_id

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this BlockVolumeAttachment.
        The IP address of block volume attachment.


        :return: The ip_address of this BlockVolumeAttachment.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this BlockVolumeAttachment.
        The IP address of block volume attachment.


        :param ip_address: The ip_address of this BlockVolumeAttachment.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        **[Required]** Gets the port of this BlockVolumeAttachment.
        The port of block volume attachment.


        :return: The port of this BlockVolumeAttachment.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this BlockVolumeAttachment.
        The port of block volume attachment.


        :param port: The port of this BlockVolumeAttachment.
        :type: int
        """
        self._port = port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
